/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization.CoercePropertyComparisonToCogMDXIn;

public class DropDuplicateDetailFilter
extends Transformation {
    public static final String COERCE_PROPERTY_COMPARISON_TO_COG_MDX_IN_NEEDS_TO_BE_APPLIED_FIRST = "CoercePropertyComparisonToCogMDXIn needs to be applied first.";

    public DropDuplicateDetailFilter() {
        this.mName = "Drop Duplicate Detail Filter";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{1010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXDetailFilter targetCogMDXDetailFilter = (CogMDXDetailFilter)node;
        if (targetCogMDXDetailFilter.pushDetailFilterToRelationalProvider()) {
            this.traceQueryCondition(false, "Detail filter pushed to the relational query, not applicable.", trace);
            return false;
        }
        if (!targetCogMDXDetailFilter.validateChildCategories()) {
            this.traceQueryCondition(true, "The child categories of the target CogMDXDetailFilter node are invalid.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)targetCogMDXDetailFilter.getAncestorOfType(1002);
        if (mdxQuery == null) {
            targetCogMDXDetailFilter.throwInternalError("Internal Error.");
        }
        if (DropDuplicateDetailFilter.requiresCoercePropertyComparisonToCogMDXIn(targetCogMDXDetailFilter)) {
            this.traceNodeCondition(false, COERCE_PROPERTY_COMPARISON_TO_COG_MDX_IN_NEEDS_TO_BE_APPLIED_FIRST, trace);
            return false;
        }
        IXQEQueryNode[] cogMDXDetailFilterNodes = mdxQuery.getDescendantsOfType(1010, false);
        for (int i = 0; i < cogMDXDetailFilterNodes.length; ++i) {
            CogMDXDetailFilter cogMDXDetailFilter = (CogMDXDetailFilter)cogMDXDetailFilterNodes[i];
            if (cogMDXDetailFilter.pushDetailFilterToRelationalProvider() || cogMDXDetailFilter == targetCogMDXDetailFilter || !cogMDXDetailFilter.validateChildCategories()) continue;
            if (DropDuplicateDetailFilter.requiresCoercePropertyComparisonToCogMDXIn(cogMDXDetailFilter)) {
                this.traceNodeCondition(false, COERCE_PROPERTY_COMPARISON_TO_COG_MDX_IN_NEEDS_TO_BE_APPLIED_FIRST, trace);
                return false;
            }
            if (!((AbstractMDXBooleanExpression)targetCogMDXDetailFilter.getChild(0)).isLogicallyEquivalent((AbstractMDXBooleanExpression)cogMDXDetailFilter.getChild(0))) continue;
            this.traceNodeCondition(true, "The CogMDXDetailFilter node is a duplicate.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The CogMDXDetailFilter node is not a duplicate.", trace);
        return false;
    }

    public static boolean requiresCoercePropertyComparisonToCogMDXIn(CogMDXDetailFilter targetCogMDXDetailFilter) {
        IXQEQueryNode[] mdxComparisonOperators;
        for (IXQEQueryNode mdxComparisonOperator : mdxComparisonOperators = targetCogMDXDetailFilter.getDescendantsOfType(1070, false)) {
            if (!CoercePropertyComparisonToCogMDXIn.nodeCondition(mdxComparisonOperator, null)) continue;
            return true;
        }
        return false;
    }
}

