/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashSet;

public class DropRedundantDetailFilter
extends Transformation {
    public DropRedundantDetailFilter() {
        this.mName = "Drop Duplicate Detail Filter";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{1010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((CogMDXDetailFilter)node).pushDetailFilterToRelationalProvider()) {
            this.traceNodeCondition(false, "Detail filter pushed to the relational query, not applicable.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target CogMDXDetailFilter node are invalid.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        if (node.getChild(0).getType() != 1029) {
            this.traceNodeCondition(false, "The first child of the filter is not a CogMDXIn expression.", trace);
            return false;
        }
        CogMDXIn in = (CogMDXIn)node.getChild(0);
        IHierarchy hierarchy = null;
        if (in.getChild(0).getType() == 1040 && in.getChild(0).getChild(0).getType() == 1073) {
            hierarchy = ((BaseHierarchy)in.getChild(0).getChild(0)).getHierarchy();
        }
        if (hierarchy == null) {
            this.traceNodeCondition(false, "The filter is not on a hierarchy", trace);
            return false;
        }
        HashSet<String> members = new HashSet<String>();
        if (in.getChild(1).getType() != 1039) {
            this.traceNodeCondition(false, "The right-hand side of the filter is not an explicit member set", trace);
            return false;
        }
        for (IXQEQueryNode child : in.getChild(1).getChildren()) {
            if (child.getType() != 1067) {
                this.traceNodeCondition(false, "The right-hand side of the filter contains something other than BaseMembers", trace);
                return false;
            }
            members.add(((BaseMember)child).getExternalName());
        }
        if (members.size() < 2) {
            this.traceNodeCondition(false, "The right-hand side of the filter only contains a single member.", trace);
            return false;
        }
        IXQEQueryNode[] cogMDXDetailFilterNodes = mdxQuery.getDescendantsOfType(1010, false);
        for (int i = 0; i < cogMDXDetailFilterNodes.length; ++i) {
            if (((CogMDXDetailFilter)cogMDXDetailFilterNodes[i]).pushDetailFilterToRelationalProvider() || cogMDXDetailFilterNodes[i] == node || !cogMDXDetailFilterNodes[i].validateChildCategories() || cogMDXDetailFilterNodes[i].getChild(0).getType() != 1029) continue;
            CogMDXIn otherIn = (CogMDXIn)cogMDXDetailFilterNodes[i].getChild(0);
            Object otherHierarchy = null;
            if (otherIn.getChild(0).getType() == 1040 && otherIn.getChild(0).getChild(0).getType() == 1073) {
                otherHierarchy = ((BaseHierarchy)otherIn.getChild(0).getChild(0)).getHierarchy();
            }
            if (otherHierarchy == null || !otherHierarchy.equals(hierarchy)) continue;
            String otherMember = null;
            if (otherIn.getChild(1).getType() != 1039 || otherIn.getChild(1).getNumberChildren() > 1 || otherIn.getChild(1).getChild(0).getType() != 1067 || !members.contains(otherMember = ((BaseMember)otherIn.getChild(1).getChild(0)).getExternalName())) continue;
            this.traceNodeCondition(true, "The CogMDXDetailFilter node is redundant.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The CogMDXDetailFilter node is not redundant.", trace);
        return false;
    }
}

