/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXAnd;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class MergeANDdCogMDXInConditions
extends Transformation {
    public MergeANDdCogMDXInConditions() {
        this.mName = "Merge ANDd CogMDXIn Conditions.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{1029};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXHierInfo hierInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo();
        IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
        IXQEQueryNode intersectSet = node.detachChild(1);
        CogMDXIn target = this.findMergeTargetForORdCogMDXInCondition((CogMDXIn)node, hierarchy);
        IXQEQueryNode mdxDistinct = factory.createNode(1033);
        mdxDistinct.setPropertyValue("logicalOperator", 1110);
        IXQEQueryNode mdxSet = factory.createNode(1039);
        target.getChild(1).insertParent(mdxSet);
        target.getChild(1).insertParent(mdxDistinct);
        mdxSet.addChild(intersectSet);
        IXQEQueryNode parent = node.getParent();
        node.detach();
        parent.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!((CogMDXIn)node).isNormalized()) {
            this.traceNodeCondition(false, "The target CogMDXIn node has has not yet been normalized by the NormalizeCogMDXIn transformation.", trace);
            return false;
        }
        if (node.getParent().getType() != 1110) {
            this.traceNodeCondition(false, "The parent of the target CogMDXIn node is not an MDXAnd node.", trace);
            return false;
        }
        IXQEQueryNode cogMDXDetailFilter = node.getAncestorOfType(1010);
        if (cogMDXDetailFilter == null) {
            this.traceNodeCondition(false, "The CogMDXIn node is not a descendant of a CogMDXDetailFilter node.", trace);
            return false;
        }
        IXQEQueryNode[] cogMDXInNodes = cogMDXDetailFilter.getDescendantsOfType(1029, false);
        for (int i = 0; i < cogMDXInNodes.length; ++i) {
            if (((CogMDXIn)cogMDXInNodes[i]).isNormalized()) continue;
            this.traceNodeCondition(false, "The ancestor CogMDXDetailFilter node condition contains a CogMDXIn node that has not yet been normalized by the NormalizeCogMDXIn transformation.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target CogMDXIn node are invalid.", trace);
            return false;
        }
        if (node.getChild(0).getType() != 1040 || node.getChild(0).getChild(0).getType() != 1073) {
            this.traceNodeCondition(false, "The first operand of the CogMDXIn node is not an MDXMembers function on a base hierarchy.  NormalizeCogMDXIn must be applied to the target CogMDXIn node before thistransformation can be applied.", trace);
            return false;
        }
        MDXHierInfo hierInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo();
        IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
        CogMDXIn target = this.findMergeTargetForORdCogMDXInCondition((CogMDXIn)node, hierarchy);
        if (target != null) {
            this.traceNodeCondition(true, "Located another CogMDXIn condition to merge the target node with in the current AND condition chain.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Unable to locate another CogMDXIn condition to merge the target node with in the current AND condition chain.", trace);
        return false;
    }

    private CogMDXIn findMergeTargetForORdCogMDXInCondition(CogMDXIn cogMDXIn, IHierarchy hierarchy) {
        if (cogMDXIn.getParent().getType() != 1110) {
            cogMDXIn.getParent().throwInternalError("Node is not of type MDXAnd.");
        }
        MDXAnd mdxAnd = (MDXAnd)cogMDXIn.getParent();
        AbstractMDXBooleanExpression[] adjANDOperands = mdxAnd.getAssociativeOperands(false);
        for (int i = 0; i < adjANDOperands.length; ++i) {
            AbstractMDXBooleanExpression operand = adjANDOperands[i];
            if (operand == cogMDXIn || operand.getType() != 1029) continue;
            MDXHierInfo targetHierInfo = ((AbstractMDXSet)operand.getChild(0)).getHierarchyInfo();
            CogMDXIn target = (CogMDXIn)operand;
            if (targetHierInfo.getNumProjectedHierarchies() != 1 || targetHierInfo.getProjectedHierarchy(0) != hierarchy) continue;
            return target;
        }
        return null;
    }
}

