/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization.DropDuplicateDetailFilter;

public class MergeValueDetailFilters
extends Transformation {
    public MergeValueDetailFilters() {
        this.mName = "Merge Value Detail Filters";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{1010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] cogMDXDetailFilterNodes = mdxQuery.getDescendantsOfType(1010, false);
        for (int i = 0; i < cogMDXDetailFilterNodes.length; ++i) {
            if (cogMDXDetailFilterNodes[i] == node || !cogMDXDetailFilterNodes[i].validateChildCategories() || !((AbstractMDXBooleanExpression)cogMDXDetailFilterNodes[i].getChild(0)).isConditionsOnValueExpressions()) continue;
            IXQEQueryNode mdxAnd = factory.createNode(1110);
            cogMDXDetailFilterNodes[i].getChild(0).insertParent(mdxAnd);
            mdxAnd.addChild(node.detachChild(0));
            break;
        }
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXDetailFilter cogMDXDetailFilter;
        int i;
        IXQEQueryNode[] cogMDXDetailFilterNodes;
        XQETrace trace = environment.getTrace();
        CogMDXDetailFilter targetCogMDXDetailFilter = (CogMDXDetailFilter)node;
        if (targetCogMDXDetailFilter.pushDetailFilterToRelationalProvider()) {
            this.traceQueryCondition(false, "Detail filter pushed to the relational query, not applicable.", trace);
            return false;
        }
        if (!targetCogMDXDetailFilter.validateChildCategories()) {
            this.traceQueryCondition(false, "The child categories of the target node are invalid.", trace);
            return false;
        }
        if (!((AbstractMDXBooleanExpression)targetCogMDXDetailFilter.getChild(0)).isConditionsOnValueExpressions()) {
            this.traceQueryCondition(false, "The target node condition is not comprised entirely of conditions on value expressions.", trace);
            return false;
        }
        if (DropDuplicateDetailFilter.requiresCoercePropertyComparisonToCogMDXIn(targetCogMDXDetailFilter)) {
            this.traceNodeCondition(false, "CoercePropertyComparisonToCogMDXIn needs to be applied first.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)targetCogMDXDetailFilter.getAncestorOfType(1002);
        if (mdxQuery == null) {
            targetCogMDXDetailFilter.throwInternalError("Internal Error.");
        }
        if ((cogMDXDetailFilterNodes = mdxQuery.getDescendantsOfType(1010, false)).length == 1) {
            this.traceNodeCondition(false, "There is no other CogMDXDetailFilter condition.", trace);
            return false;
        }
        for (i = 0; i < cogMDXDetailFilterNodes.length; ++i) {
            cogMDXDetailFilter = (CogMDXDetailFilter)cogMDXDetailFilterNodes[i];
            for (int j = i + 1; j < cogMDXDetailFilterNodes.length; ++j) {
                CogMDXDetailFilter cogMDXDetailFilterNext = (CogMDXDetailFilter)cogMDXDetailFilterNodes[j];
                if (!((AbstractMDXBooleanExpression)cogMDXDetailFilterNext.getChild(0)).isLogicallyEquivalent((AbstractMDXBooleanExpression)cogMDXDetailFilter.getChild(0))) continue;
                this.traceQueryCondition(false, "There is CogMDXDetailFilter condition that is logically equivalent to another CogMDXDetailFilter condition and should be removed.", trace);
                return false;
            }
        }
        for (i = 0; i < cogMDXDetailFilterNodes.length; ++i) {
            cogMDXDetailFilter = (CogMDXDetailFilter)cogMDXDetailFilterNodes[i];
            if (cogMDXDetailFilter == targetCogMDXDetailFilter || !cogMDXDetailFilter.validateChildCategories() || !DropDuplicateDetailFilter.requiresCoercePropertyComparisonToCogMDXIn(cogMDXDetailFilter)) continue;
            this.traceNodeCondition(false, "CoercePropertyComparisonToCogMDXIn needs to be applied first.", trace);
            return false;
        }
        for (i = 0; i < cogMDXDetailFilterNodes.length; ++i) {
            if (cogMDXDetailFilterNodes[i] == targetCogMDXDetailFilter || !cogMDXDetailFilterNodes[i].validateChildCategories() || !((AbstractMDXBooleanExpression)cogMDXDetailFilterNodes[i].getChild(0)).isConditionsOnValueExpressions()) continue;
            this.traceNodeCondition(true, "The target CogMDXDetailFilter condition can be merged with another CogMDXDetailFilter condition.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The target CogMDXDetailFilter condition cannot be merged with another CogMDXDetailFilter condition.", trace);
        return false;
    }
}

