/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.validation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractDetailFilter;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import java.util.HashSet;

public final class ValidateDFsWithRMFunctions
extends Transformation {
    private int[] rmFnTypes = new int[]{1047, 1035, 1074, 1157, 1050, 1049, 1075, 1051, 1034, 1156, 1147};

    public ValidateDFsWithRMFunctions() {
        this.mName = "Validate DFs With Relative Member Functions.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{1093, 1094, 1107, 1095};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) throws XQEOlapUnsupportedQueryException {
        TNodeAbstractDetailFilter tNode = (TNodeAbstractDetailFilter)node;
        XQEMessage message = null;
        if (tNode.isMasterDetailFilter()) {
            String masterDetailLinkDescription = tNode.getMasterDetailLinkDescription();
            message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedQueryMasterDetailWithRelativeMemberFunction, masterDetailLinkDescription, (IXQEQueryNode)tNode);
        } else {
            String filterExpr = tNode.getOriginalExpression();
            message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedQueryDFWithRelativeMemberFunction, filterExpr, (IXQEQueryNode)tNode);
        }
        throw new XQERuntimeException(message);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        String timing;
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The target CogMDXDetailFilter node has invalid child nodes.", trace);
            return false;
        }
        if (node.getPropertyValue("isDMRDuplicateFilterOnHierarchy") != null && node.getPropertyValue("isDMRDuplicateFilterOnHierarchy").equals(Boolean.TRUE)) {
            this.traceNodeCondition(false, "The target CogMDXDetailFilter is an exact duplicate of a filter that is pushed to relational.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if ((node.getType() == 1093 || node.getType() == 1095) && (timing = ((TNodeAbstractDetailFilter)node).getPostAutoAggregationTiming(mdxQuery)).equals("reportDetails") && (node.getType() != 1093 || ((TNodeMDFOnSingleHierarchy)node).getPostAutoAggregation())) {
            this.traceNodeCondition(false, "The Detail Filter timing is set to 'reportDetails'", trace);
            return false;
        }
        IXQEQueryNode[] rmFns = mdxQuery.getDescendantsOfTypes(this.rmFnTypes, false);
        if (rmFns.length == 0) {
            this.traceNodeCondition(false, "The MDXQuery does not contain a relative member function.", trace);
            return false;
        }
        HashSet<IHierarchy> invalidHierarchies = new HashSet<IHierarchy>();
        if (node.getType() == 1095) {
            invalidHierarchies.addAll(mdxQuery.getHierarchyInfo().getProjectedHierarchies());
        } else {
            IXQEQueryNode[] cogMDXInNodes = node.getDescendantsOfType(1029, false);
            if (cogMDXInNodes.length == 0) {
                this.traceNodeCondition(false, "The target CogMDXDetailFilter node does not have any descendant CogMDXIn nodes.", trace);
                return false;
            }
            for (int i = 0; i < cogMDXInNodes.length; ++i) {
                CogMDXIn cogMDXIn = (CogMDXIn)cogMDXInNodes[i];
                MDXHierInfo hierInfo = ((MDXMembers)cogMDXIn.getChild(0)).getHierarchyInfo();
                invalidHierarchies.add(hierInfo.getProjectedHierarchy(0));
            }
        }
        for (IXQEQueryNode rmFn : rmFns) {
            MDXHierInfo rmHierInfo;
            if (rmFn.getAncestorOfTypes(this.mTypes) != null || !invalidHierarchies.contains((rmHierInfo = ((AbstractMDXNode)rmFn).getHierarchyInfo()).getProjectedHierarchy(0))) continue;
            this.traceNodeCondition(true, "The MDXQuery uses a relative member function that will be affected by a detail filter condition.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The MDXQuery does not use any relative member functions that will be affected by a member detail filter condition.", trace);
        return false;
    }
}

