/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.validation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractDetailFilter;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleUnrefHierarchy;
import com.cognos.xqe.ast.olap.TNodeORdMDFsAndVDFs;
import com.cognos.xqe.ast.olap.TNodeORdMDFsOnDiffHiers;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public final class ValidateDetailFilterTiming
extends Transformation {
    public ValidateDetailFilterTiming() {
        this.mName = "Validate Detail Filter Timing.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{1093, 1094, 1107, 1108, 1095};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) throws XQEOlapUnsupportedQueryException {
        TNodeAbstractDetailFilter tNode;
        tNode.setPostAutoAggregation(!(tNode = (TNodeAbstractDetailFilter)node).getPostAutoAggregation());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        int severityOfMessage = 1;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        TNodeAbstractDetailFilter tNode = (TNodeAbstractDetailFilter)node;
        if (tNode.getPostAutoAggregation()) {
            if (tNode.getType() == 1094) {
                IHierarchy hierarchy = ((TNodeMDFOnSingleUnrefHierarchy)tNode).getMDFHierarchy();
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(severityOfMessage, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_PostAutoAggregationMDF, hierarchy.toString()));
                this.traceNodeCondition(true, "Cannot have a post auto aggregation detail filter on an unreferenced hierarchy.", trace);
                return true;
            }
            if (tNode.getType() == 1093) {
                IHierarchy hierarchy = ((TNodeMDFOnSingleHierarchy)tNode).getMDFHierarchy();
                if (!mdxQuery.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                    environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(severityOfMessage, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_PostAutoAggregationMDF, hierarchy.toString()));
                    this.traceNodeCondition(true, "Cannot have a post auto aggregation detail filter on the unprojected hierarchy " + hierarchy, trace);
                    return true;
                }
                String timing = tNode.getPostAutoAggregationTiming(mdxQuery);
                if (!timing.equals("reportDetails")) {
                    MDXLevelInfo levelInfo = mdxQuery.getLevelInfo();
                    ILevel lowestProjectedLevel = levelInfo.getLowestProjectedLevel(hierarchy);
                    AbstractMDXSet dfSet = (AbstractMDXSet)tNode.getChild(0).getChild(1);
                    MDXLevelInfo dfLevelInfo = dfSet.getLevelInfo();
                    ILevel lowestFilterLevel = dfLevelInfo.getLowestProjectedLevel(hierarchy);
                    if (lowestFilterLevel != null && lowestProjectedLevel != null && lowestFilterLevel.getIndex() > lowestProjectedLevel.getIndex()) {
                        environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(severityOfMessage, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_PostAutoAggregationMDFLevelBelowDetails, hierarchy.toString()));
                        this.traceNodeCondition(true, "Cannot have a post auto aggregation detail filter where the context in the " + hierarchy + " hierarchy in the filter contains members from levels below those of the projected details.", trace);
                        return true;
                    }
                }
            }
        } else {
            boolean correlateHierarchyDF;
            Object projectedParentChildHierarchy = null;
            boolean bl = correlateHierarchyDF = tNode.getCorrelatedHierarchies() != null;
            if (tNode.getType() != 1095 && correlateHierarchyDF) {
                MDXHierInfo hierInfo = null;
                if (tNode.getType() == 1093) {
                    hierInfo = new MDXHierInfo();
                    hierInfo.appendProjectedHierarchy(((TNodeMDFOnSingleHierarchy)tNode).getMDFHierarchy());
                } else if (tNode.getType() == 1107) {
                    hierInfo = ((TNodeORdMDFsOnDiffHiers)tNode).getMDFHierarchyInfo();
                } else if (tNode.getType() == 1108) {
                    hierInfo = ((TNodeORdMDFsAndVDFs)tNode).getMDFHierarchyInfo();
                }
                if (hierInfo != null) {
                    int notCorrHierCount = 0;
                    for (IHierarchy hierarchy : hierInfo.getProjectedHierarchies()) {
                        if (hierarchy.getDimension().isMeasuresDimension()) {
                            ++notCorrHierCount;
                            continue;
                        }
                        if (!tNode.doCorrelate(hierarchy)) {
                            correlateHierarchyDF = false;
                            projectedParentChildHierarchy = hierarchy;
                            continue;
                        }
                        ++notCorrHierCount;
                    }
                    if (projectedParentChildHierarchy != null && notCorrHierCount > 0) {
                        throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedComplexFilterWithHMDF, projectedParentChildHierarchy.toString());
                    }
                }
            }
            if (tNode.getType() == 1095 || tNode.getType() == 1108) {
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(severityOfMessage, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_BeforeAutoAggregationVDF));
                this.traceNodeCondition(true, "A value detail filter cannot be applied before auto aggregation.", trace);
                return true;
            }
            if (projectedParentChildHierarchy != null && tNode.getCorrelatedHierarchies() != null) {
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(severityOfMessage, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_BeforeAutoAggregationHDF, projectedParentChildHierarchy.toString()));
                this.traceNodeCondition(true, "A member detail filter on a hierarchy cannot be applied before auto aggregation.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "The detail filter has a valid timing.", trace);
        return false;
    }
}

