/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.validation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import java.util.List;

public final class ValidateMembersInVirtualCubeForVDF
extends Transformation {
    public ValidateMembersInVirtualCubeForVDF() {
        this.mName = "Validate Members in the Virtual Cube for VDF.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{1095, 1108};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) throws XQEOlapUnsupportedQueryException {
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "Unable to find the ancestor MDXQuery node.", trace);
            return false;
        }
        String timing = ((TNodeAbstractDetailFilter)node).getPostAutoAggregationTiming(mdxQuery);
        if (timing.equals("reportDetails")) {
            this.traceNodeCondition(false, "The Detail Filter timing is set to 'reportDetails'", trace);
            return false;
        }
        int[] categories = new int[]{1065, 1067};
        MDXEdge[] edges = mdxQuery.getEdges();
        MDXLevelInfo queryLevelInfo = mdxQuery.getLevelInfo();
        for (MDXEdge edge : edges) {
            List<AbstractMDXNode> references = edge.getDescendantsOfCategories(categories, true, true, true, false, false);
            for (AbstractMDXNode baseNode : references) {
                IHierarchy hierarchy;
                MDXLevelInfo baseLevelInfo = baseNode.getLevelInfo();
                if (baseLevelInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1 || baseLevelInfo.getNumProjectedLevels(hierarchy = baseLevelInfo.getHierarchyInfo().getProjectedHierarchy(0)) == 0) continue;
                ILevel baseLevel = baseLevelInfo.getProjectedLevel(hierarchy, 0);
                if (!queryLevelInfo.getHierarchyInfo().projectsHierarchy(hierarchy) || queryLevelInfo.getProjectedLevelsSkipCalculation(hierarchy).size() == 0) continue;
                ILevel lowestProjectedLevel = queryLevelInfo.getLowestProjectedLevel(hierarchy);
                if (baseLevel.getIndex() <= lowestProjectedLevel.getIndex()) continue;
                throw new XQERuntimeException(XQEMessageKeys.PLN_VDFAndMembersFromLowerLevelThanProjMembers, hierarchy.getName());
            }
        }
        this.traceNodeCondition(false, "The MDXQuery does not reference members from a level lower than the projected levels.", trace);
        return false;
    }
}

