/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXSummaryFilter;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeApplySummaryFilterToSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public class DistributeScopelessSummaryFilter
extends Transformation {
    public DistributeScopelessSummaryFilter() {
        this.mName = "DistributeScopelessSummaryFilter";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{1011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        CogMDXSummaryFilter summaryFilter = (CogMDXSummaryFilter)node;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            MDXHierInfo edgeHierInfo = edges[i].getHierarchyInfo();
            if (edgeHierInfo.getNumberOfNonMeasureHierarchiesProjected() <= 0) continue;
            TNodeApplySummaryFilterToSet tNode = (TNodeApplySummaryFilterToSet)factory.createNode(1141, summaryFilter);
            List<IXQEQueryNode> cogMDXGroupNodes = edges[i].getDescendantsOfCategoryOrdered(1027, false);
            for (IXQEQueryNode grp : cogMDXGroupNodes) {
                if (grp.getType() == 1080) continue;
                CogMDXGroup topCogMDXGroup = (CogMDXGroup)grp;
                tNode.setSummaryFilterId(node.getId());
                topCogMDXGroup.getChild(0).insertParent(tNode);
                break;
            }
            node.setPropertyValue("SummaryFilterDistributed", Boolean.TRUE);
            break;
        }
        if (node.getPropertyValue("SummaryFilterDistributed") == null || node.getPropertyValue("SummaryFilterDistributed") != Boolean.TRUE) {
            TNodeApplySummaryFilterToSet tNode = (TNodeApplySummaryFilterToSet)factory.createNode(1141, summaryFilter);
            List<IXQEQueryNode> cogMDXGroupNodes = edges[0].getDescendantsOfCategoryOrdered(1027, false);
            CogMDXGroup topCogMDXGroup = (CogMDXGroup)cogMDXGroupNodes.get(0);
            tNode.setSummaryFilterId(node.getId());
            topCogMDXGroup.getChild(0).insertParent(tNode);
        }
        node.setPropertyValue("SummaryFilterDistributed", Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target CogMDXSummaryFilter node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        if (node.getPropertyValue("SummaryFilterDistributed") == Boolean.TRUE) {
            this.traceNodeCondition(false, "The summary filter has already been distributed.", trace);
            return false;
        }
        if (node.getPropertyValue("ValidateSummaryFilterConditionApplied") != Boolean.TRUE) {
            this.traceNodeCondition(false, "The ValidateSummaryFilterCondition transformation has not yet been applied to the target node.", trace);
            return false;
        }
        CogMDXSummaryFilter summaryFilter = (CogMDXSummaryFilter)node;
        List<String> scopedDataItemNames = summaryFilter.getScopedDataItemNames();
        if (scopedDataItemNames.size() > 0) {
            this.traceNodeCondition(false, "The target CogMDXSummaryFilter has explicit scopes. DistributeSummaryFilterToSets should be applied.", trace);
            return false;
        }
        if (summaryFilter.getDefaultScopeName().compareTo("report") == 0) {
            this.traceNodeCondition(true, "The target CogMDXSummaryFilter has for report scope.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The CogMDXSummaryFilter doesn't have for report scope.", trace);
        return false;
    }
}

