/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveSummaryFilterNode
extends Transformation {
    public RemoveSummaryFilterNode() {
        this.mName = "Remove Summary Filter Transformation Nodes.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{1011, 1174};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("SummaryFilterDistributed") != Boolean.TRUE) {
            this.traceNodeCondition(false, "The target node has not yet been distributed to the MDXQuery.", trace);
            return false;
        }
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        IXQEQueryNode[] cogMDXSummaryFilterNodes = mdxQuery.getDescendantsOfTypes(new int[]{1011, 1174}, false);
        for (int i = 0; i < cogMDXSummaryFilterNodes.length; ++i) {
            if (cogMDXSummaryFilterNodes[i] == node || cogMDXSummaryFilterNodes[i].getPropertyValue("SummaryFilterDistributed") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "The MDXQuery still contains Summary Filter nodes that have not yet been distributed to the MDXQuery.", trace);
            return false;
        }
        IXQEQueryNode[] tNodes = mdxQuery.getDescendantsOfTypes(new int[]{1141, 1175}, false);
        if (tNodes.length > 0) {
            this.traceNodeCondition(false, "The query contains TNodeApplySummaryFilterToSet nodes that must be processed before this transformation can be applied to the target node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target CogMDXSummaryFilter node can be removed.", trace);
        return true;
    }
}

