/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.util;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXHeadTailFunction;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.TNodeApplyHeadSuppression;
import com.cognos.xqe.ast.olap.TNodeHeadCount;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public final class ApplyHeadSuppression
extends Transformation {
    public ApplyHeadSuppression() {
        this.mName = "Apply Head Suppression.";
        this.mPassNumbers = new int[]{39};
        this.mTypes = new int[]{1083};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        TNodeHeadCount tHeadCount = ((TNodeApplyHeadSuppression)node).getTNodeHeadCount();
        int unsuppressedSetSize = tHeadCount.getConstantValue();
        AbstractMDXSet tupleSet = (AbstractMDXSet)node.detachChild(0);
        MDXHeadTailFunction mdxHead = null;
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        boolean suppressOnNonEmpty = false;
        if (edge != null) {
            suppressOnNonEmpty = edge.applyExcludeEmptyHeadSuppression();
        }
        if (unsuppressedSetSize == -1) {
            AbstractMDXNumericValueExpression mdxPlusOperator = null;
            while (node.getNumberChildren() > 0) {
                MDXCount mdxCount = MDXBuilder.buildMDXCountExpr(factory, (AbstractMDXSet)node.detachChild(0), true);
                mdxCount.setHeadSuppression(true);
                if (suppressOnNonEmpty) {
                    mdxCount.setIncludeEmpty(false);
                }
                if (mdxPlusOperator != null) {
                    mdxPlusOperator = MDXBuilder.buildMDXNumericOperator((IXQENodeFactory)factory, 1, mdxPlusOperator, mdxCount);
                    continue;
                }
                mdxPlusOperator = mdxCount;
            }
            AbstractMDXSet tupleCopy = (AbstractMDXSet)MDXBuilder.deepCopyExcludingCMDefs(factory, tupleSet, false);
            MDXCount mdxCount2 = MDXBuilder.buildMDXCountExpr(factory, tupleCopy, true);
            mdxCount2.setHeadSuppression(true);
            MDXComparisonOperator suppressionCondition = MDXBuilder.buildMDXComparisonExpr(factory, 3, mdxPlusOperator, MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, XQEIntegerPool.getInteger(0)));
            MDXNumericIIF mdxIIF = MDXBuilder.buildMDXNumericIIFExpr(factory, suppressionCondition, mdxCount2, MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, XQEIntegerPool.getInteger(0)));
            mdxHead = MDXBuilder.buildMDXHeadExpr(factory, tupleSet, mdxIIF);
        } else {
            AbstractMDXNumericValueExpression mdxPlusOperator = null;
            while (node.getNumberChildren() > 0) {
                MDXCount mdxCount;
                if (suppressOnNonEmpty) {
                    mdxCount = MDXBuilder.buildMDXCountExpr(factory, (AbstractMDXSet)node.detachChild(0), true);
                    mdxCount.setIncludeEmpty(false);
                } else {
                    mdxHead = MDXBuilder.buildMDXHeadExpr(factory, (AbstractMDXSet)node.detachChild(0));
                    mdxHead.setHeadSuppression(true);
                    mdxCount = MDXBuilder.buildMDXCountExpr(factory, mdxHead, true);
                }
                mdxCount.setHeadSuppression(true);
                if (mdxPlusOperator != null) {
                    mdxPlusOperator = MDXBuilder.buildMDXNumericOperator((IXQENodeFactory)factory, 1, mdxPlusOperator, mdxCount);
                    continue;
                }
                mdxPlusOperator = mdxCount;
            }
            if (unsuppressedSetSize > 1) {
                MDXComparisonOperator suppressionCondition = MDXBuilder.buildMDXComparisonExpr(factory, 3, mdxPlusOperator, MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, XQEIntegerPool.getInteger(0)));
                MDXNumericIIF mdxIIF = MDXBuilder.buildMDXNumericIIFExpr(factory, suppressionCondition, MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, XQEIntegerPool.getInteger(unsuppressedSetSize)), MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, XQEIntegerPool.getInteger(0)));
                mdxHead = MDXBuilder.buildMDXHeadExpr(factory, tupleSet, mdxIIF);
            } else {
                mdxHead = MDXBuilder.buildMDXHeadExpr(factory, tupleSet, mdxPlusOperator);
            }
        }
        node.getParent().exchangeChildNode(node, mdxHead, false);
        mdxHead.setHeadSuppression(true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        TNodeHeadCount tCount = ((TNodeApplyHeadSuppression)node).getTNodeHeadCount();
        if (tCount == null || !tCount.getIsConverted()) {
            this.traceNodeCondition(false, "The TNodeHeadCount need to be changed to number first.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The TNodeApplyHeadSuppression node does not have valid child nodes.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The TNodeApplyHeadSuppression node has valid child nodes.", trace);
        return true;
    }
}

