/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIUsage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class CollectMeasuresIntersectingWithProjCalcUtil {
    public static Set<AbstractMDXMember> getProjectedMeasureAncestors(AbstractMDXNode abstractMDXNode) {
        CogMDXGroup group = (CogMDXGroup)abstractMDXNode.getParentWhereDescendantOfChildAtIndexForNodeOfType(1027, 1, true);
        if (group == null) {
            return new HashSet<AbstractMDXMember>();
        }
        AbstractMDXSet firstChild = (AbstractMDXSet)group.getChild(0);
        if (firstChild.getHierarchyInfo().projectsMeasures()) {
            return CollectMeasuresIntersectingWithProjCalcUtil.getProjectedMeasureDescendants(firstChild);
        }
        return CollectMeasuresIntersectingWithProjCalcUtil.getProjectedMeasureAncestors(group);
    }

    public static Set<AbstractMDXMember> getProjectedMeasureDescendants(AbstractMDXNode abstractMDXNode) {
        int[] categories = new int[]{1067, 1013, 1077};
        boolean checkCMDefs = false;
        boolean checkNSDefs = true;
        boolean checkSADefs = true;
        boolean ignoreTNOps = false;
        boolean includeSelf = false;
        List<AbstractMDXNode> measureDescendants = abstractMDXNode.getDescendantsOfCategories(categories, checkCMDefs, checkNSDefs, checkSADefs, ignoreTNOps, includeSelf);
        HashSet<AbstractMDXMember> projMeasureDescendants = new HashSet<AbstractMDXMember>();
        for (AbstractMDXMember abstractMDXMember : measureDescendants) {
            RSAPIDataItem dataItem;
            if (!abstractMDXMember.getHierarchy().getDimension().isMeasuresDimension() || !abstractMDXNode.isProjectedDescendant(abstractMDXMember)) continue;
            boolean isFact = true;
            CogMDXGroup group = (CogMDXGroup)abstractMDXMember.getAncestorOfType(1027);
            if (!(group == null || group.isNonDetailGroupBodyValue() && group.getAncestorOfCategory(1028) != null || (dataItem = group.getFirstRSAPIDataItem()) == null)) {
                boolean bl = isFact = dataItem.getUsage() == RSAPIUsage.FACT;
            }
            if (!isFact) continue;
            projMeasureDescendants.add(abstractMDXMember);
        }
        return projMeasureDescendants;
    }

    public static Set<AbstractMDXMember> collectMeasuresIntersectingWithProjCalc(MDXCalculatedMemberDefinition calcDef, MDXQuery mdxQuery) {
        HashSet<AbstractMDXMember> intersectingMeasures = new HashSet<AbstractMDXMember>();
        CollectMeasuresIntersectingWithProjCalcUtil.addProjMeasuresIntersectingWithRefToCalcDef(calcDef, mdxQuery, intersectingMeasures);
        MDXCalculatedMemberDefinition[] calcDefs = mdxQuery.getCalcMemberDefinitions();
        for (int i = 0; i < calcDefs.length; ++i) {
            MDXCalculatedMemberDefinition intersectingCalc = calcDefs[i];
            if (calcDef == intersectingCalc || intersectingCalc.getSolveOrder() <= calcDef.getSolveOrder() && intersectingCalc.getHierarchy().getDimension().isMeasuresDimension()) continue;
            IXQEQueryNode[] refBaseMembers = intersectingCalc.getDescendantsOfTypes(new int[]{1067, 1013}, false);
            for (int j = 0; j < refBaseMembers.length; ++j) {
                AbstractMDXMember member = (AbstractMDXMember)refBaseMembers[j];
                if (!member.getHierarchy().getDimension().isMeasuresDimension()) continue;
                boolean foundMeasure = false;
                Iterator it = intersectingMeasures.iterator();
                while (it.hasNext()) {
                    if (!member.isSameExpression((IXQEQueryNode)it.next(), false)) continue;
                    foundMeasure = true;
                    break;
                }
                if (foundMeasure) continue;
                intersectingMeasures.add(member);
            }
        }
        return intersectingMeasures;
    }

    public static void addProjMeasuresIntersectingWithRefToCalcDef(MDXCalculatedMemberDefinition calcDef, MDXQuery mdxQuery, Set<AbstractMDXMember> intersectingMeasures) {
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            MDXEdge currEdge = edges[i];
            if (!currEdge.getHierarchyInfo().projectsMeasures()) continue;
            ArrayList<IXQEQueryNode> projectedReferences = new ArrayList<IXQEQueryNode>();
            currEdge.getProjectedReference(projectedReferences, calcDef);
            for (MDXCalculatedMemberReference mDXCalculatedMemberReference : projectedReferences) {
                AbstractMDXNode group;
                intersectingMeasures.addAll(CollectMeasuresIntersectingWithProjCalcUtil.getProjectedMeasureAncestors(mDXCalculatedMemberReference));
                if (intersectingMeasures.size() == 0) {
                    group = (AbstractMDXNode)mDXCalculatedMemberReference.getParentWhereDescendantOfChildAtIndexForNodeOfType(1027, 1, true);
                    if (group == null) {
                        group = (AbstractMDXNode)mDXCalculatedMemberReference.getParentWhereDescendantOfChildAtIndexForNodeOfType(1039, 1, true);
                    }
                    if (group != null && group.getNumberChildren() == 2) {
                        intersectingMeasures.addAll(CollectMeasuresIntersectingWithProjCalcUtil.getProjectedMeasureDescendants((AbstractMDXNode)group.getChild(1)));
                    }
                }
                if (intersectingMeasures.size() != 0 || (group = (AbstractMDXNode)mDXCalculatedMemberReference.getAncestorOfType(1027)) == null || group.getNumberChildren() != 2) continue;
                intersectingMeasures.addAll(CollectMeasuresIntersectingWithProjCalcUtil.getProjectedMeasureDescendants(group));
            }
            if (!projectedReferences.isEmpty()) break;
            intersectingMeasures.addAll(CollectMeasuresIntersectingWithProjCalcUtil.getProjectedMeasureDescendants(currEdge));
            break;
        }
    }
}

