/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.validate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXSlicer;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ValidateCogMDXSlicer
extends AbstractV5ToCogMDXTransformation {
    public ValidateCogMDXSlicer() {
        this.mName = "Validate parameters to see if they have been resolved.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1009};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] calcMemRefs;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfCategory(1002);
        Set<Object> referencedHierarchies = new LinkedHashSet();
        for (MDXEdge edge : mdxQuery.getEdges()) {
            referencedHierarchies = edge.getReferencedHierarchies();
        }
        for (IXQEQueryNode calcMemRef : calcMemRefs = node.getDescendantsOfType(1013, false)) {
            MDXCalculatedMemberReference mdxCalcRef = (MDXCalculatedMemberReference)calcMemRef;
            for (IHierarchy iHierarchy : referencedHierarchies) {
                IXQEQueryNode ancestorMDXSetOp;
                if (iHierarchy.getDimension().isMeasuresDimension() || !mdxCalcRef.getHierarchyInfo().projectsHierarchy(iHierarchy) || (ancestorMDXSetOp = mdxCalcRef.getAncestorOfCategory(1056)) != null && !((AbstractMDXNode)ancestorMDXSetOp.getChild(0)).getHierarchyInfo().projectsHierarchy(iHierarchy)) continue;
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedQuerySlicerOnCalculation2, ((CogMDXSlicer)node).getOriginalExpression(), mdxQuery.getV5NameProperty(), iHierarchy.getV5UniqueName());
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] calcMemRefs;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfCategory(1002);
        Set<Object> referencedHierarchies = new LinkedHashSet();
        MDXHierInfo projectedHier = null;
        for (MDXEdge edge : mdxQuery.getEdges()) {
            referencedHierarchies = edge.getReferencedHierarchies();
            if (projectedHier == null) {
                projectedHier = edge.getHierarchyInfo();
                continue;
            }
            projectedHier.appendProjectedHierarchies(edge.getHierarchyInfo());
        }
        for (IXQEQueryNode calcMemRef : calcMemRefs = node.getDescendantsOfType(1013, false)) {
            MDXCalculatedMemberReference mdxCalcRef = (MDXCalculatedMemberReference)calcMemRef;
            for (IHierarchy iHierarchy : referencedHierarchies) {
                IXQEQueryNode ancestorMDXSetOp;
                if (iHierarchy.getDimension().isMeasuresDimension() || !mdxCalcRef.getHierarchyInfo().projectsHierarchy(iHierarchy) || (ancestorMDXSetOp = mdxCalcRef.getAncestorOfCategory(1056)) != null && !((AbstractMDXNode)ancestorMDXSetOp.getChild(0)).getHierarchyInfo().projectsHierarchy(iHierarchy)) continue;
                this.traceNodeCondition(true, "Slicer on user defined calculation uses a hierarchy that is referenced elsewhere in the report.", trace);
                return true;
            }
        }
        MDXHierInfo hierInfo = ((CogMDXSlicer)node).getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() == 1) {
            ILevel highLevel;
            ILevel lowLevel;
            IHierarchy hier;
            ICube cube;
            String string;
            IXQEQueryNode setNode;
            int aSeverity = 1;
            String slicerExpr = ((CogMDXSlicer)node).getOriginalExpression();
            if (projectedHier.projectedHierarchiesOverlap(hierInfo)) {
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_SlicerWithOverlappingProjectedLevels, mdxQuery.getRefQueryProperty(), slicerExpr));
            }
            if ((setNode = node.getFirstChildByType(1039)) != null && setNode.getNumberChildren() > 1 && DataSourceTypeEnum.isYukon(string = (cube = (hier = hierInfo.getProjectedHierarchy(0)).getDimension().getCube()).getModelDataSource().getInterface()) && !(lowLevel = ((MDXSet)setNode).getLowestReferencedLevel(hier)).equals(highLevel = ((MDXSet)setNode).getHighestReferencedLevel(hier))) {
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_SlicerWithOverlappingLevels, mdxQuery.getRefQueryProperty(), slicerExpr));
            }
        }
        this.traceNodeCondition(false, "Slicer on user defined calculations is valid.", trace);
        return false;
    }
}

