/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.validate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.validate.ValidateWithinDetailSummary;

public final class ValidateMDXQuery
extends Transformation {
    public ValidateMDXQuery() {
        this.mName = "Validate MDX Query.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode invalidNode = ((MDXQuery)node).getInvalidMDXDescendantNodeBottomUpOrder();
        String nodeName = invalidNode.getNodeTypeName();
        throw new XQERuntimeException(XQEMessageKeys.PLN_V5PlanFailed, nodeName);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] summaries = node.getDescendantsOfType(201032, false);
        if (node.getDescendantsOfType(201032, false).length > 0) {
            for (IXQEQueryNode summary : summaries) {
                if (!ValidateWithinDetailSummary.isWithinDetailV5Summary(summary)) continue;
                this.traceQueryCondition(false, "ValidateWithinDetailSummary must handle this case.", trace);
                return false;
            }
        }
        if (((MDXQuery)node).validateDescendantCategories()) {
            this.traceQueryCondition(false, "The MDXQuery node is valid.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The MDXQuery node is invalid.", trace);
        return true;
    }
}

