/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.validate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class ValidateYukonMultipleHierarchies
extends Transformation {
    public ValidateYukonMultipleHierarchies() {
        this.mName = "Validate MDX Query.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
    }

    private String getRelatedBaseHierarchy(MDXQuery mdxQuery, IHierarchy first, IHierarchy second) {
        ILevel lowestLevelSecondHierarchy;
        if (this.isAttributeHierarchy(first) && this.isAttributeHierarchy(second)) {
            return null;
        }
        ILevel lowestLevelFirstHierarchy = mdxQuery.getLowestReferencedLevel(first);
        String related = this.getRelatedToBaseHierarchies(lowestLevelFirstHierarchy, lowestLevelSecondHierarchy = mdxQuery.getLowestReferencedLevel(second));
        if (related != null) {
            return related;
        }
        return this.getRelatedToBaseHierarchies(lowestLevelSecondHierarchy, lowestLevelFirstHierarchy);
    }

    private boolean isAttributeHierarchy(IHierarchy hier) {
        String value = (String)hier.getProperty("attributeHierarchy");
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    private List<String> getBaseHierarchies(ILevel level) {
        ArrayList<String> relatedHierarchyNames = new ArrayList<String>();
        List<ILevel> levelList = level.getHierarchy().getLevels();
        for (int i = 0; i <= level.getIndex(); ++i) {
            ILevel aboveLevel = levelList.get(i);
            String baseAttrHierarchy = (String)aboveLevel.getProperty("baseAttributeHierarchyRef");
            if (baseAttrHierarchy == null) continue;
            relatedHierarchyNames.add(baseAttrHierarchy);
        }
        return relatedHierarchyNames;
    }

    private String getRelatedToBaseHierarchies(ILevel relatedTo, ILevel relatedFrom) {
        List<String> relatedToList = this.getBaseHierarchies(relatedTo);
        List<String> relatedFromList = relatedFrom.getHierarchy().getRelatedHierarchyNames(relatedFrom);
        if (relatedToList != null && relatedFromList != null) {
            for (int i = 0; i < relatedToList.size(); ++i) {
                String firstName = relatedToList.get(i);
                for (int j = 0; j < relatedFromList.size(); ++j) {
                    if (!firstName.equals(relatedFromList.get(j))) continue;
                    return firstName;
                }
            }
        }
        return null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!((MDXQuery)node).isYukonProvider()) {
            this.traceQueryCondition(false, "The provider type is not Yukon.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node;
        mdxQuery.getReferencedHierarchies();
        Set<IHierarchy> referencedHierarchies = ((MDXQuery)node).getReferencedHierarchies();
        for (IHierarchy first : referencedHierarchies) {
            for (IHierarchy second : referencedHierarchies) {
                if (first == second || first.getDimension() != second.getDimension() || this.getRelatedBaseHierarchy(mdxQuery, first, second) == null) continue;
                if (first.getUniqueName().compareTo(second.getUniqueName()) > 0) {
                    IHierarchy tempHier = first;
                    first = second;
                    second = tempHier;
                }
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedYukonHierarchies, first.getUniqueName(), second.getUniqueName(), this.getRelatedBaseHierarchy(mdxQuery, first, second));
            }
        }
        this.traceQueryCondition(false, "The MDXQuery node contains valid multiple hierarchies from the same dimension.", trace);
        return false;
    }
}

