/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFlatten;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;

public final class BindRSAPIDataset
extends RQETransformation {
    public BindRSAPIDataset() {
        this(0);
    }

    public BindRSAPIDataset(int passNumber) {
        this.mName = "Add SQLFlatten nodes.";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{401005};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RSAPIDataset dataSet = (RSAPIDataset)node;
        RSAPIEdge[] edges = dataSet.getEdges();
        SQLQueryItemList queryItems = new SQLQueryItemList();
        for (int i = 0; i < edges.length; ++i) {
            RSAPIDataItem[] dataItems;
            RSAPIEdgeRowset rowset = edges[i].getRowset(0);
            for (RSAPIDataItem dataItem : dataItems = rowset.getDataItems()) {
                SQLQueryItem qItem = new SQLQueryItem(dataItem.getName(), dataItem.getBaseDataType());
                qItem.setModelReference(dataItem.getModelReference());
                queryItems.add(qItem);
            }
        }
        int columnNo = 0;
        for (SQLQueryItem qItem : queryItems) {
            qItem.setColumnNo(columnNo++);
        }
        SQLFlatten fNode = (SQLFlatten)nodeFactory.createNode(301052);
        fNode.setQueryItemList(queryItems);
        node.insertParent(fNode);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parent = node.getParent();
        boolean bl = status = parent instanceof SQLQueryNode && parent.getType() != 301052;
        if (status) {
            this.traceQueryCondition(status, "Parent node is a SQL query node.", trace);
        } else {
            this.traceQueryCondition(status, "Parent node is not a SQL query node.", trace);
        }
        return status;
    }
}

