/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLNativeSql;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindNativeSQLException;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindRelationNotFoundException;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class BindSQLNativeSql
extends RQETransformation {
    public BindSQLNativeSql() {
        this(3);
    }

    public BindSQLNativeSql(int passNumber) {
        this.mName = "Bind SQLNativeSql node.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301012};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) throws BindRelationNotFoundException {
        SQLNativeSql nativeSQLNode = (SQLNativeSql)node;
        IDataSource dataSource = SQLBinderUtil.getDatasource(environment, nativeSQLNode);
        if (dataSource.getDataSourceConnection().getConnectionString().toLowerCase().contains("ibmcognos.typeinsqldisabled")) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UserDefinedSQLforDataSourceDenied, dataSource.getDataSourceConnection().getName());
        }
        if (!SQLBinderUtil.getMetaData(environment, nativeSQLNode, dataSource, nativeSQLNode.getSqlString())) {
            throw new BindNativeSQLException(nativeSQLNode.getSqlString());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = (node.getPropertyValue("queryItems") == null || this.queryItemHasNullDataType((SQLQueryItemList)node.getPropertyValue("queryItems"))) && node.getAncestorOfType(301004) != null;
        if (status) {
            this.traceQueryCondition(status, "Native SQL query has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "Native query SQL has been bound.", trace);
        }
        return status;
    }

    private boolean queryItemHasNullDataType(SQLQueryItemList queryItems) {
        for (SQLQueryItem sqlQueryItem : queryItems) {
            if (sqlQueryItem.getDataType() != null) continue;
            return true;
        }
        return false;
    }
}

