/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class SQLQueryItemList
extends ArrayList<SQLQueryItem>
implements IXQEPersist {
    private static final long serialVersionUID = 1L;
    private static final String STRING_NAME = "name";
    private int contextNo;
    private SQLQueryItemList parent;

    public SQLQueryItemList() {
    }

    public SQLQueryItemList(int nItems) {
        super(nItems);
    }

    public int getContextNo() {
        return this.contextNo;
    }

    public void setContextNo(int theContextNo) {
        this.contextNo = theContextNo;
    }

    public SQLQueryItemList getParent() {
        return this.parent;
    }

    public void setParent(SQLQueryItemList theParent) {
        this.parent = theParent;
    }

    public SQLQueryItemList copy() {
        SQLQueryItemList qItemList = new SQLQueryItemList(this.size());
        for (SQLQueryItem qItem : this) {
            qItemList.add(qItem.copy());
        }
        return qItemList;
    }

    public IDataType getDataType() {
        RowType rowType = DataTypeFactory.getRowType();
        for (SQLQueryItem qItem : this) {
            rowType.addField(qItem.getName(), qItem.getDataType());
        }
        return rowType;
    }

    public SQLQueryItem getQueryItem(SQLQueryItem qItem) {
        String tableName = qItem.getTableName();
        for (SQLQueryItem queryItem : this) {
            if (tableName != null && !tableName.equals(queryItem.getTableName()) || !qItem.getName().equals(queryItem.getName())) continue;
            return queryItem;
        }
        return null;
    }

    public SQLQueryItem getQueryItem(SQLFid fid) {
        String tableName = fid.getTableName();
        for (SQLQueryItem queryItem : this) {
            if (tableName != null && !tableName.equals(queryItem.getTableName()) || !fid.getName().equals(queryItem.getName())) continue;
            return queryItem;
        }
        return null;
    }

    public SQLQueryItem getParameterQueryItem(SQLFid fid) {
        String tableName = fid.getTableName();
        for (SQLQueryItem queryItem : this) {
            if (!queryItem.isParameter() || tableName != null && !tableName.equals(queryItem.getTableName()) || !fid.getName().equals(queryItem.getName())) continue;
            return queryItem;
        }
        return null;
    }

    public SQLQueryItem getQueryItem(String name) {
        for (SQLQueryItem queryItem : this) {
            if (!name.equals(queryItem.getName())) continue;
            return queryItem;
        }
        return null;
    }

    public boolean hasParameters() {
        for (SQLQueryItem qItem : this) {
            if (!qItem.isParameter()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            for (SQLQueryItem val : this) {
                ctx.elementProperty(null, val);
            }
            ctx.endElement();
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int index = 0; index < nChildren; ++index) {
            Object childValue = ctx.elementValue((Element)childList.get(index));
            if (childValue == null) continue;
            this.add((SQLQueryItem)childValue);
        }
    }
}

