/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class AdjustSQLTop
extends RQETransformation {
    public AdjustSQLTop() {
        this.mName = "Adjust SQLTop node.";
        this.mPassNumbers = new int[]{8};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mTypes = new int[]{301060};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode literal = node.getChild(1).extract();
        IXQEQueryNode distinct = node.getChild(0);
        if (distinct.getType() == 301019) {
            distinct = distinct.getChild(0);
        }
        node.extract();
        distinct.addChild(node);
        node.addChild(distinct.getChild(0).detach());
        node.addChild(literal);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        if (qBlock != null && qBlock.isForeign()) {
            IDataSourceCapabilities capabilities;
            if (node.getChild(0).getType() == 301019) {
                node = node.getChild(0);
            }
            if (node.getChild(0).getType() == 301008 && (capabilities = qBlock.getDataSource().getCapabilities()).getStringValue("clauses.Top.Position", "standard").equals("distinct.top")) {
                status = true;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Top/Distinct need to be switched.", trace);
        } else {
            this.traceQueryCondition(status, "Top/Distinct do not need to be switched", trace);
        }
        return status;
    }
}

