/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.IOutputList;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class CollapseSortNodes
extends RQETransformation {
    public CollapseSortNodes() {
        this.mName = "Collapse sort nodes.";
        this.mPassNumbers = new int[]{5};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mTypes = new int[]{301019};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSortKeyList keyList1 = ((SQLSort)node).getSortKeyList();
        int nKeys = keyList1.getNumberChildren();
        IXQEQueryNode child = node.getChild(0);
        if (child.getType() == 301019) {
            SQLSortKeyList keyList2 = ((SQLSort)node).getSortKeyList();
            if (nKeys > keyList2.getNumberChildren()) {
                IXQEQueryNode[] keys = keyList1.getChildren();
                for (int i = keyList2.getNumberChildren(); i < nKeys; ++i) {
                    keys[i].move(keyList2);
                }
            }
        } else {
            while (child.getType() != 301015 && child.getType() != 901020) {
                if (child.getType() == 301022) {
                    child = child.getChild(child.getNumberChildren() - 1);
                    continue;
                }
                child = child.getChild(0);
            }
            SQLSort sortNode = (SQLSort)child.getFirstDescendantOfTypeOrdered(301019, false);
            SQLSortKeyList keyList2 = sortNode.getSortKeyList();
            if (nKeys > keyList2.getNumberChildren()) {
                SQLSortKey sortKey;
                int i;
                SQLValueList valueList = ((IOutputList)((Object)child)).getOutputList();
                SQLFid[] fidList = new SQLFid[nKeys];
                for (i = 0; i < nKeys; ++i) {
                    sortKey = (SQLSortKey)keyList1.getChild(i);
                    fidList[i] = (SQLFid)valueList.getChild(sortKey.getColumnNo());
                }
                for (child = child.getChild(0); child != sortNode; child = child.getChild(0)) {
                    if (child.getType() != 301015 && child.getType() != 901020) continue;
                    valueList = ((IOutputList)((Object)child)).getOutputList();
                    for (i = 0; i < fidList.length; ++i) {
                        fidList[i] = (SQLFid)valueList.getChild(fidList[i].getVirtualColumnNo());
                    }
                }
                for (i = keyList2.getNumberChildren(); i < nKeys; ++i) {
                    sortKey = (SQLSortKey)keyList1.getChild(i);
                    SQLFid fid2 = (SQLFid)nodeFactory.deepCopyNode(fidList[i]);
                    keyList2.addSortKey(nodeFactory, fid2, sortKey.isAscending(), sortKey.getNullOrder());
                }
            }
        }
        node.getChild(1).detach();
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode child = node.getChild(0);
        boolean bl = status = !((SQLSort)node).isDistinct();
        if (status) {
            while (child.getType() == 301015 || child.getType() == 301009 || child.getType() == 901020) {
                child = child.getChild(0);
            }
            boolean bl2 = status = child.getType() == 301019;
        }
        if (status) {
            IXQEQueryNode keyList1 = node.getChild(1);
            IXQEQueryNode keyList2 = child.getChild(1);
            child = node.getChild(0);
            if (child.getType() == 301019) {
                int nKeys = Math.min(keyList1.getNumberChildren(), keyList2.getNumberChildren());
                for (int i = 0; i < nKeys && status; ++i) {
                    SQLSortKey sortKey2;
                    SQLSortKey sortKey1 = (SQLSortKey)keyList1.getChild(i);
                    if (sortKey1.isSameExpression(sortKey2 = (SQLSortKey)keyList2.getChild(i), false)) continue;
                    status = false;
                }
            } else {
                int i;
                int nKeys = keyList1.getNumberChildren();
                while (child.getType() != 301015 && child.getType() != 901020) {
                    if (child.getType() == 301022) {
                        child = child.getChild(child.getNumberChildren() - 1);
                        continue;
                    }
                    child = child.getChild(0);
                }
                SQLValueList valueList = ((IOutputList)((Object)child)).getOutputList();
                SQLFid[] fidList = new SQLFid[nKeys];
                for (i = 0; i < nKeys; ++i) {
                    SQLSortKey sortKey = (SQLSortKey)keyList1.getChild(i);
                    IXQEQueryNode eNode = valueList.getChild(sortKey.getColumnNo());
                    if (eNode.getType() != 301032) {
                        status = false;
                        break;
                    }
                    fidList[i] = (SQLFid)eNode;
                }
                if (status) {
                    child = child.getChild(0);
                    while (child.getType() != 301019 && status) {
                        if (child.getType() == 301015 || child.getType() == 901020) {
                            valueList = ((IOutputList)((Object)child)).getOutputList();
                            for (i = 0; i < fidList.length; ++i) {
                                IXQEQueryNode eNode = valueList.getChild(fidList[i].getVirtualColumnNo());
                                if (eNode.getType() != 301032) {
                                    status = false;
                                    break;
                                }
                                fidList[i] = (SQLFid)eNode;
                            }
                        }
                        if (child.getNumberChildren() == 0) break;
                        child = child.getChild(0);
                    }
                }
                if (status) {
                    nKeys = Math.min(keyList1.getNumberChildren(), keyList2.getNumberChildren());
                    for (i = 0; i < nKeys && status; ++i) {
                        SQLSortKey sortKey1 = (SQLSortKey)keyList1.getChild(i);
                        SQLSortKey sortKey2 = (SQLSortKey)keyList2.getChild(i);
                        if (sortKey1.isAscending() == sortKey2.isAscending() && sortKey1.getNullOrder() == sortKey2.getNullOrder()) {
                            SQLFid fid = (SQLFid)sortKey2.getChild(0);
                            if (fid.getVirtualColumnNo() == fidList[i].getVirtualColumnNo()) continue;
                            status = false;
                            continue;
                        }
                        status = false;
                    }
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Sort query block can be collapsed.", trace);
        } else {
            this.traceQueryCondition(status, "Sort query block cannot be collapsed.", trace);
        }
        return status;
    }
}

