/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.qep.QEPCollect;
import com.cognos.xqe.ast.qep.QEPDistribute;
import com.cognos.xqe.ast.qep.QEPJoin;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLPartition;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.resultsets.tabular.Join;
import com.cognos.xqe.resultsets.tabular.Relation;
import com.cognos.xqe.runtree.relational.XDistribute;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.Planner;

public class CreateParallelJoinPlan
extends RQETransformation {
    public CreateParallelJoinPlan() {
        this.mName = "Create parallel join plan.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{901014};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        Planner planner = new Planner(environment);
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int dop = configuration.getMaxDop();
        QEPCollect collector = (QEPCollect)planner.createPlan(901016);
        node.insertParent(collector);
        collector.setDop(dop);
        SQLPartition[] partitionList = new SQLPartition[2];
        for (int i = 0; i < 2; ++i) {
            partitionList[i] = (SQLPartition)factory.createNode(301042);
        }
        for (Join join : ((QEPJoin)node).getJoins()) {
            Relation left = join.getLeftJoin();
            Relation right = join.getRightJoin();
            SQLFid fid = (SQLFid)factory.createNode(301032);
            fid.setVirtualColumnNo(left.getColumnNo());
            partitionList[0].addChild(fid);
            fid = (SQLFid)factory.createNode(301032);
            fid.setVirtualColumnNo(right.getColumnNo());
            partitionList[1].addChild(fid);
        }
        for (int i = 0; i < 2; ++i) {
            QEPDistribute distributor = (QEPDistribute)planner.createPlan(901017);
            distributor.setDop(dop);
            distributor.setPartitioningType(XDistribute.PartitioningType.HASH);
            node.getChild(i).insertParent(distributor);
            distributor.addChild(factory.deepCopyNode(partitionList[i]));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean bl = status = node.getParent().getType() != 901016 && configuration.isParallelismEnabled() && configuration.getMaxDop() > 1;
        if (status) {
            this.traceQueryCondition(status, "A parallel join plan can be created.", trace);
        } else {
            this.traceQueryCondition(status, "A parallel join plan cannot be created.", trace);
        }
        return status;
    }
}

