/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;

public class GenerateTypeCastsForSetOperators
extends RQETransformation {
    public GenerateTypeCastsForSetOperators() {
        this.mName = "Generate type casting for set operators.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301018};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLSetOperator setOp = (SQLSetOperator)node;
        SQLQueryItemList qItems = setOp.getQueryItemList();
        for (int i = 0; i < setOp.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)setOp.getChild(i);
            if (child.getType() == 301018) continue;
            SQLValueList vList = child.getOutputList();
            for (int j = 0; j < vList.getNumberChildren(); ++j) {
                SQLQueryItem qItem = (SQLQueryItem)qItems.get(j);
                SQLQueryNode exprNode = (SQLQueryNode)vList.getChild(j);
                if (exprNode.getDataType().exactlyEquivalent(qItem.getDataType())) continue;
                SQLDataType dTypeNode = (SQLDataType)factory.createNode(301037);
                dTypeNode.setDataType(qItem.getDataType());
                IXQEQueryNode castNode = factory.createNode(301047);
                exprNode.insertParent(castNode);
                castNode.addChild(dTypeNode);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        IDataSource dataSource;
        IDataSourceCapabilities capabilities;
        XQETrace trace = environment.getTrace();
        SQLSetOperator setOp = (SQLSetOperator)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        SQLQueryItemList qItems = setOp.getQueryItemList();
        boolean status = false;
        if (qBlock != null && qBlock.isForeign() && !(capabilities = (dataSource = qBlock.getDataSource()).getCapabilities()).getBooleanValue("supports.implicitTypeConversion")) {
            for (int i = 0; i < setOp.getNumberChildren() && !status; ++i) {
                SQLValueList vList = ((SQLQueryNode)setOp.getChild(i)).getOutputList();
                for (int j = 0; j < vList.getNumberChildren() && !status; ++j) {
                    SQLQueryItem qItem = (SQLQueryItem)qItems.get(j);
                    SQLQueryNode exprNode = (SQLQueryNode)vList.getChild(j);
                    status = !exprNode.getDataType().exactlyEquivalent(qItem.getDataType());
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Set operator requires type casting.", trace);
        } else {
            this.traceQueryCondition(status, "Set operator does not require type casting.", trace);
        }
        return status;
    }
}

