/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class NormalizeRegexFunction
extends RQETransformation {
    public NormalizeRegexFunction() {
        this.mName = "Normalize a Regex scalar function node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301033};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLFunction.SubType subType = ((SQLFunction)node).getSubType();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            IXQEQueryNode childNode = node.getChild(i);
            if (childNode.getType() != 301070) continue;
            SQLLiteral literal = (SQLLiteral)factory.createNode(301031);
            if (SQLFunction.SubType.POSITION_REGEX == subType && 0 == i) {
                literal.setValue(DataValueFactory.createCharValue("BEFORE"));
            } else if (SQLFunction.SubType.SUBSTRING_REGEX == subType && 4 == i || SQLFunction.SubType.OCCURRENCES_REGEX == subType && 3 == i || SQLFunction.SubType.POSITION_REGEX == subType && 5 == i) {
                literal.setValue(DataValueFactory.createCharValue(""));
            } else {
                literal.setValue(DataValueFactory.createIntegerValue(1));
            }
            childNode.exchange(literal);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = pQueryBlock != null && !pQueryBlock.isForeign();
        if (status) {
            SQLFunction.SubType subType = ((SQLFunction)node).getSubType();
            boolean bl2 = status = (SQLFunction.SubType.SUBSTRING_REGEX == subType || SQLFunction.SubType.OCCURRENCES_REGEX == subType || SQLFunction.SubType.POSITION_REGEX == subType) && node.getDescendantsOfType(301070, false).length > 0;
        }
        if (status) {
            this.traceQueryCondition(status, "Regex function needs to be normalized.", trace);
        } else {
            this.traceQueryCondition(status, "Regex function doesn't need to be normalized.", trace);
        }
        return status;
    }
}

