/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class NormalizeSQLComparison
extends RQETransformation {
    public NormalizeSQLComparison() {
        this.mName = "Normalize SQLComparison node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301026, 301076};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        if (node.getType() == 301076) {
            IXQEQueryNode rowConstructor = factory.createNode(301040);
            node.getChild(0).insertParent(rowConstructor);
        } else {
            SQLComparison comparison = (SQLComparison)node;
            IXQEQueryNode lhs = node.detachFirstChild();
            node.addChild(lhs);
            SQLComparison.SubType subType = comparison.getSubType();
            switch (subType) {
                case GREATER: {
                    subType = SQLComparison.SubType.LESS;
                    break;
                }
                case GREATEREQUAL: {
                    subType = SQLComparison.SubType.LESSEQUAL;
                    break;
                }
                case LESS: {
                    subType = SQLComparison.SubType.GREATER;
                    break;
                }
                case LESSEQUAL: {
                    subType = SQLComparison.SubType.GREATEREQUAL;
                    break;
                }
            }
            comparison.setSubType(subType);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = ((SQLQueryNode)node).getParentQueryBlock();
        boolean bl = status = !qBlock.isForeign();
        if (status) {
            if (node.getType() == 301076) {
                status = node.getChild(1).getType() == 301059 && node.getChild(0).getType() != 301040;
            } else if (node.getFirstChildByType(301055) != null) {
                status = false;
            } else {
                SQLComparison comparison = (SQLComparison)node;
                IDataType[] pTypes = comparison.getParameterTypes();
                status = DataTypeComparator.requiresPromotionForComparison(pTypes[0], pTypes[1]);
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Comparison operator needs to be normalized.", trace);
        } else {
            this.traceQueryCondition(status, "Comparison operator doesn't need to be normalized.", trace);
        }
        return status;
    }
}

