/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class NormalizeSQLLiteral
extends RQETransformation {
    private static final String SPACE = " ";
    private static final String UNSUPPORTED_END_TIME = "23:59:59.999000000";
    private static final String LITERALEXCEPTION = "literals.exception.End_Time_Literal";

    public NormalizeSQLLiteral() {
        this.mName = "Normalize SQLLiteral node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301009};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSourceCapabilities capabilities = qBlock.getDataSource().getCapabilities();
        SQLExpression predicate = ((SQLFilter)node).getPredicate();
        String targetTime = this.getEndDayOfTimeStr(capabilities);
        List<IXQEQueryNode> litList = predicate.getDescendantsOfTypeOrdered(301031, false);
        for (int i = 0; i < litList.size(); ++i) {
            String newStr;
            SQLLiteral litNode = (SQLLiteral)litList.get(i);
            if (!litNode.getDataType().isTime() && !litNode.getDataType().isTimestamp()) continue;
            String[] valueArray = litNode.getValue().toString().split(SPACE);
            if (valueArray.length == 1 && valueArray[0].compareTo(UNSUPPORTED_END_TIME) == 0) {
                newStr = valueArray[0].replace(UNSUPPORTED_END_TIME, targetTime);
                litNode.setValue(newStr);
                continue;
            }
            if (valueArray[1].compareTo(UNSUPPORTED_END_TIME) != 0) continue;
            newStr = valueArray[1].replace(UNSUPPORTED_END_TIME, targetTime);
            String finalStr = valueArray[0] + SPACE + newStr;
            litNode.setValue(finalStr);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = qBlock != null && qBlock.isForeign();
        if (status) {
            IDataSourceCapabilities capabilities;
            String getStr;
            SQLExpression predicate = ((SQLFilter)node).getPredicate();
            List<IXQEQueryNode> litList = predicate.getDescendantsOfTypeOrdered(301031, false);
            status = false;
            if (litList.size() != 0 && (getStr = this.getEndDayOfTimeStr(capabilities = qBlock.getDataSource().getCapabilities())) != null) {
                for (int i = 0; i < litList.size(); ++i) {
                    SQLLiteral litNode = (SQLLiteral)litList.get(i);
                    if (!litNode.getDataType().isTime() && !litNode.getDataType().isTimestamp()) continue;
                    String[] litValue = litNode.getValue().getString().split(SPACE);
                    if (litValue.length == 1) {
                        status = litValue[0].compareTo(UNSUPPORTED_END_TIME) == 0;
                    } else {
                        boolean bl2 = status = litValue[1].compareTo(UNSUPPORTED_END_TIME) == 0;
                    }
                    if (status) break;
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Time or Timestamp literal can be normalized.", trace);
        } else {
            this.traceQueryCondition(status, "Time or Timestamp literal can't be normalized.", trace);
        }
        return status;
    }

    private String getEndDayOfTimeStr(IDataSourceCapabilities capabilities) {
        String pattern = capabilities.getStringValue(LITERALEXCEPTION, null);
        return pattern;
    }
}

