/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLTrim;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class NormalizeSQLTrim
extends RQETransformation {
    public NormalizeSQLTrim() {
        this.mName = "Normalize SQLTrim node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301064};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLTrim.TrimSpec trimSpec = ((SQLTrim)node).getTrimSpec();
        IntegerValue trimSpecValue = DataValueFactory.createIntegerValue(trimSpec.value());
        SQLLiteral sqlLiteral = (SQLLiteral)factory.createNode(301031);
        sqlLiteral.setValue(trimSpecValue);
        node.addChild(sqlLiteral, 0);
        if (node.getNumberChildren() == 2) {
            sqlLiteral = (SQLLiteral)factory.createNode(301031);
            sqlLiteral.setValue(DataValueFactory.createCharValue(" "));
            node.addChild(sqlLiteral, 1);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = !pQueryBlock.isForeign() && node.getNumberChildren() <= 2;
        if (status) {
            this.traceQueryCondition(status, "Extract function needs to be normalized.", trace);
        } else {
            this.traceQueryCondition(status, "Extract function doesn't need to be normalized.", trace);
        }
        return status;
    }
}

