/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class PadCharacterLiterals
extends RQETransformation {
    private static final String SPACE = " ";

    public PadCharacterLiterals() {
        this.mName = "Pad character literals.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301026, 301076};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IDataType dataType = ((SQLQueryNode)node.getChild(0)).getDataType();
        int maxLength = dataType.getPrecision();
        if (node.getType() == 301026) {
            SQLLiteral literalNode = (SQLLiteral)node.getChild(1);
            TextValue value = (TextValue)literalNode.getValue();
            value.rPad(maxLength, SPACE);
            literalNode.setPadded(true);
        } else {
            IXQEQueryNode vList = node.getChild(1);
            for (int i = 0; i < vList.getNumberChildren(); ++i) {
                SQLLiteral literalNode = (SQLLiteral)vList.getChild(i);
                TextValue value = (TextValue)literalNode.getValue();
                if (value.getString().length() >= maxLength) continue;
                value.rPad(maxLength, SPACE);
                literalNode.setPadded(true);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean status = false;
        if (qBlock != null && !qBlock.isForeign()) {
            IDataType dataType;
            IXQEQueryNode leftChild = node.getChild(0);
            IXQEQueryNode rightChild = node.getChild(1);
            if (leftChild.getType() == 301032 && (dataType = ((SQLQueryNode)leftChild).getDataType()) instanceof CharType) {
                int maxLength = dataType.getPrecision();
                if (rightChild.getType() == 301031) {
                    if (!((SQLLiteral)rightChild).isPadded()) {
                        String value = ((SQLLiteral)rightChild).getValue().getString();
                        status = value.length() < maxLength;
                    }
                } else if (rightChild.getType() == 301030) {
                    for (int i = 0; i < rightChild.getNumberChildren() && !status; ++i) {
                        IXQEQueryNode child = rightChild.getChild(i);
                        if (child.getType() != 301031 || ((SQLLiteral)child).isPadded()) continue;
                        String value = ((SQLLiteral)child).getValue().getString();
                        status = value.length() < maxLength;
                    }
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Character literal can be padded.", trace);
        } else {
            this.traceQueryCondition(status, "Character literal cannot be padded.", trace);
        }
        return status;
    }
}

