/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import java.util.ArrayList;
import java.util.List;

public final class PredicatePushDown
extends RQETransformation {
    public PredicatePushDown() {
        this.mName = "Predicate push down.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301014, 301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLQueryNode qNode = (SQLQueryNode)node;
        IXQEQueryNode root = node;
        while (root.getParent().getType() == 301009) {
            root = root.getParent();
        }
        ArrayList<SQLFilter> factorList = new ArrayList<SQLFilter>();
        while (root.getType() == 301009) {
            factorList.add(0, (SQLFilter)root);
            root = root.getChild(0);
        }
        for (SQLFilter factor : factorList) {
            IXQEQueryNode child;
            BitMask incidence = factor.getIncidence();
            if (incidence == null || incidence.cardinality() != 1 || (child = qNode.getLeafNodeForPredicatePushdown(factor.getPredicate())) == null || !SQLPreoptimizerUtil.canPushDownPredicate(child)) continue;
            SQLQueryNode predicate = (SQLQueryNode)factor.getPredicate().detach();
            IXQEQueryNode baseNode = SQLPreoptimizerUtil.getBaseNodeForPredicatePushDown(child);
            if (baseNode.getType() == 301015) {
                baseNode.insertParent(factor.extract());
                factor.addChild(predicate);
                continue;
            }
            SQLGroupBy groupBy = (SQLGroupBy)baseNode;
            List<SQLFid> fidList = predicate.getFieldIdentifiers();
            SQLValueList vList = groupBy.getOutputList();
            for (SQLFid fid : fidList) {
                fid.exchange(factory.deepCopyNode(vList.getChild(fid.getColumnNo())));
            }
            factor.extract();
            IXQEQueryNode havingNode = groupBy.getHavingClause();
            if (havingNode != null) {
                SQLLogical lNode = (SQLLogical)factory.createNode(301027);
                lNode.setSubType(SQLLogical.SubType.AND);
                havingNode.getChild(0).insertParent(lNode);
                lNode.addChild(predicate);
                continue;
            }
            havingNode = factory.createNode(301049);
            havingNode.addChild(predicate);
            baseNode.addChild(havingNode);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryNode baseNode = (SQLQueryNode)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        boolean status = false;
        if (dataSource != null && dataSource.getCapabilities().isSupported("performance.predicatePushdown") && qBlock.isForeign() && (baseNode.getType() == 301014 || baseNode.getParent().getType() != 301011 && baseNode.getParent().getType() != 301014)) {
            IXQEQueryNode root = node;
            while (root.getParent().getType() == 301009) {
                root = root.getParent();
            }
            if (root != null) {
                while (root.getType() == 301009) {
                    IXQEQueryNode child;
                    BitMask incidence = ((SQLFilter)root).getIncidence();
                    if (incidence != null && incidence.cardinality() == 1 && (child = baseNode.getLeafNodeForPredicatePushdown(((SQLFilter)root).getPredicate())) != null && SQLPreoptimizerUtil.canPushDownPredicate(child)) {
                        status = true;
                        break;
                    }
                    root = root.getChild(0);
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Predicate push down can be performed.", trace);
        } else {
            this.traceQueryCondition(status, "Predicate push down cannot be performed.", trace);
        }
        return status;
    }
}

