/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import java.util.ArrayList;
import java.util.List;

public final class PredicatePushDownWithClause
extends RQETransformation {
    public PredicatePushDownWithClause() {
        this.mName = "Predicate push down for WITH clause.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301022};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLQueryNode root = (SQLQueryNode)node.getChild(node.getNumberChildren() - 1);
        root = (SQLQueryNode)root.getFilterNode();
        ArrayList<SQLFilter> factorList = new ArrayList<SQLFilter>();
        while (root.getType() == 301009) {
            factorList.add(0, (SQLFilter)root);
            root = (SQLQueryNode)root.getChild(0);
        }
        block1: for (SQLFilter factor : factorList) {
            IXQEQueryNode child;
            BitMask incidence = factor.getIncidence();
            if (incidence == null || incidence.cardinality() != 1 || ((child = root).getType() == 301014 || child.getType() == 301011) && (child = root.getLeafNodeForPredicatePushdown(factor.getPredicate())) == null) continue;
            if (child.getType() == 301007 && child.getChild(0).getType() == 301016) {
                child = (SQLQueryNode)child.getChild(0);
            }
            if (child.getType() != 301016 || !((SQLRelation)child).isWithClauseQueryRef()) continue;
            for (int i = 0; i < node.getNumberChildren() - 1; ++i) {
                SQLRangeVar rangeVar = (SQLRangeVar)node.getChild(i);
                if (!rangeVar.getName().equals(((SQLRelation)child).getName())) continue;
                if (!SQLPreoptimizerUtil.canPushDownPredicate(rangeVar, factor.getPredicate())) continue block1;
                SQLQueryNode predicate = (SQLQueryNode)factor.getPredicate().detach();
                IXQEQueryNode baseNode = SQLPreoptimizerUtil.getBaseNodeForPredicatePushDown(rangeVar);
                if (baseNode.getType() == 301015) {
                    baseNode.insertParent(factor.extract());
                    factor.addChild(predicate);
                    continue block1;
                }
                List<SQLFid> fidList = predicate.getFieldIdentifiers();
                SQLValueList vList = ((SQLProject)baseNode).getOutputList();
                for (SQLFid fid : fidList) {
                    fid.exchange(factory.deepCopyNode(vList.getChild(fid.getColumnNo())));
                }
                factor.extract();
                IXQEQueryNode havingNode = factory.createNode(301049);
                havingNode.addChild(predicate);
                baseNode.addChild(havingNode);
                continue block1;
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        boolean status = false;
        if (dataSource != null && dataSource.getCapabilities().isSupported("performance.predicatePushdown") && qBlock.isForeign()) {
            IXQEQueryNode root = node.getChild(node.getNumberChildren() - 1);
            if ((root = ((SQLQueryNode)root).getFilterNode()) != null) {
                SQLQueryNode baseNode = (SQLQueryNode)root;
                while (baseNode.getType() == 301009) {
                    baseNode = (SQLQueryNode)baseNode.getChild(0);
                }
                while (root.getType() == 301009) {
                    BitMask incidence = ((SQLFilter)root).getIncidence();
                    if (incidence != null && incidence.cardinality() == 1) {
                        IXQEQueryNode child = baseNode;
                        SQLExpression predicate = ((SQLFilter)root).getPredicate();
                        if (child.getType() != 301014 && child.getType() != 301011 || (child = baseNode.getLeafNodeForPredicatePushdown(predicate)) != null) {
                            if (child.getType() == 301007 && child.getChild(0).getType() == 301016) {
                                child = (SQLQueryNode)child.getChild(0);
                            }
                            if (child.getType() != 301016 || ((SQLRelation)child).isWithClauseQueryRef()) {
                                SQLRangeVar rangeVar = null;
                                for (int i = 0; i < node.getNumberChildren() - 1 && !(rangeVar = (SQLRangeVar)node.getChild(i)).getName().equals(((SQLRelation)child).getName()); ++i) {
                                }
                                if (SQLPreoptimizerUtil.canPushDownPredicate(rangeVar, predicate)) {
                                    status = true;
                                    break;
                                }
                            }
                        }
                    }
                    root = root.getChild(0);
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Predicate push down can be performed.", trace);
        } else {
            this.traceQueryCondition(status, "Predicate push down cannot be performed.", trace);
        }
        return status;
    }
}

