/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.qep.QEPHashJoin;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.resultsets.tabular.Join;
import com.cognos.xqe.resultsets.tabular.Relation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.List;

public class RemoveGroupByBelowHashJoin
extends RQETransformation {
    public RemoveGroupByBelowHashJoin() {
        this.mName = "Remove SQLGroupBy node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        QEPHashJoin hashJoin = (QEPHashJoin)node.getParent();
        hashJoin.setNoDuplicatesInBuildTable(true);
        node.detachChildrenExceptFirst();
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parent = node.getParent();
        boolean bl = status = parent.getType() == 901015 && parent.getChild(0) == node;
        if (status) {
            List<Join> joins = ((QEPHashJoin)parent).getJoins();
            SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
            status = joins.size() == groupByList.getNumberChildren();
            for (int i = 0; i < groupByList.getNumberChildren() && status; ++i) {
                Relation relation = joins.get(i).getLeftJoin();
                SQLFid fid = (SQLFid)groupByList.getChild(i);
                status = fid.getVirtualColumnNo() == relation.getColumnNo();
            }
        }
        if (status) {
            this.traceQueryCondition(status, "GROUP BY node can be removed.", trace);
        } else {
            this.traceQueryCondition(status, "GROUP BY node cannot be removed.", trace);
        }
        return status;
    }
}

