/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.ExactNumericValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;

public class RewriteLongInPredicates
extends RQETransformation {
    private static final int MIN_BLOCK_SIZE = 50;
    private static final String COLLAPSE_HINT = "collapseInList";
    private static final String BLOCK_SIZE_HINT = "minBlockSize";
    private static final String COLLAPSE_INLIST_CONFIG = "queryPlanning.collapseLargeInLists[@enabled]";

    public RewriteLongInPredicates() {
        this.mName = "Rewrite long IN predicates.";
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mPassNumbers = new int[]{9};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mTypes = new int[]{301076};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLIn originalInClause = (SQLIn)node;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getOrCreateXQEConfiguration();
        if (config.getBooleanProperty(COLLAPSE_INLIST_CONFIG, true)) {
            this.convertInClauseToBetweenClause(originalInClause, environment);
        }
        if (originalInClause.getChild(1).getNumberChildren() == 0) {
            IXQEQueryNode parent = originalInClause.getParent();
            originalInClause.detach();
            parent.extract();
            return;
        }
        this.splitInClause(originalInClause, environment);
    }

    private void convertInClauseToBetweenClause(SQLIn inClause, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode inPredicand = inClause.getChild(0);
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)inClause.getAncestorOfType(301004);
        IXQEQueryNode inList = inClause.getChild(1);
        IXQEQueryNode[] tempNodes = inList.getChildrenOfType(301031);
        SQLLiteral[] literalNodes = (SQLLiteral[])Arrays.copyOf(tempNodes, tempNodes.length, SQLLiteral[].class);
        if (literalNodes.length == 0) {
            return;
        }
        SQLBetween between = (SQLBetween)factory.createNode(301045);
        IDataType type = literalNodes[0].getDataType();
        if (!type.isInteger() && !type.isDate()) {
            return;
        }
        between.addChild(factory.deepCopyNode(inPredicand));
        between.addChild(factory.copyNode(literalNodes[0]));
        between.addChild(factory.copyNode(literalNodes[0]));
        if (pQueryBlock != null && !between.isSupported(pQueryBlock.getDataSource())) {
            return;
        }
        Arrays.sort(literalNodes, new Comparator<SQLLiteral>(){

            @Override
            public int compare(SQLLiteral n1, SQLLiteral n2) {
                return n1.getValue().compareTo(n2.getValue());
            }
        });
        LinkedList<Pair> contiguousBlocks = new LinkedList<Pair>();
        int startIndex = 0;
        int endIndex = -1;
        ComparisonHelper comparisonHelper = type.isDate() ? new DateHelper() : new IntegerHelper();
        Value prevValue = literalNodes[0].getValue();
        Integer blockSizeHint = (Integer)inClause.getHint(BLOCK_SIZE_HINT);
        int minBlockSize = 50;
        int curBlockSize = 0;
        if (blockSizeHint != null) {
            minBlockSize = blockSizeHint;
        }
        for (int i = 1; i < literalNodes.length; ++i) {
            Value curValue = literalNodes[i].getValue();
            if (comparisonHelper.compareTo(prevValue, curValue) == 0) {
                literalNodes[i].detach();
                literalNodes[i] = null;
                continue;
            }
            if (comparisonHelper.compareToNext(prevValue, curValue) == 0) {
                endIndex = i;
                ++curBlockSize;
                prevValue = curValue;
                continue;
            }
            if (curBlockSize >= minBlockSize) {
                contiguousBlocks.add(new Pair(XQEIntegerPool.getInteger(startIndex), XQEIntegerPool.getInteger(endIndex)));
                startIndex = endIndex + 1;
            } else {
                startIndex = i;
            }
            curBlockSize = 0;
            endIndex = startIndex;
            prevValue = curValue;
        }
        if (curBlockSize >= minBlockSize) {
            contiguousBlocks.add(new Pair(XQEIntegerPool.getInteger(startIndex), XQEIntegerPool.getInteger(endIndex)));
        }
        for (Pair block : contiguousBlocks) {
            int start = (Integer)block.getFirst();
            int end = (Integer)block.getSecond();
            SQLLogical or = (SQLLogical)factory.createNode(301027);
            or.setSubType(SQLLogical.SubType.OR);
            between = (SQLBetween)factory.createNode(301045);
            between.addChild(factory.deepCopyNode(inPredicand));
            literalNodes[start].move(between);
            literalNodes[end].move(between);
            inClause.insertParent(or);
            or.addChild(between);
            for (int i = start + 1; i < end; ++i) {
                if (literalNodes[i] == null) continue;
                literalNodes[i].detach();
            }
        }
    }

    private void splitInClause(SQLIn originalInClause, IPlanningEnvironment environment) {
        IXQEQueryNode inList = originalInClause.getChild(1);
        XQENodeFactory factory = environment.getNodeFactory();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)originalInClause.getAncestorOfType(301004);
        IDataSource datasource = pQueryBlock.getDataSource();
        IDataSourceCapabilities capabilities = datasource.getCapabilities();
        int maxLengthInClause = capabilities.getIntegerValue("limits.maxLengthInClause", 0);
        if (maxLengthInClause == 0) {
            return;
        }
        for (int originalInListSize = inList.getNumberChildren(); originalInListSize > maxLengthInClause; originalInListSize -= maxLengthInClause) {
            SQLLogical orNode = (SQLLogical)factory.createNode(301027);
            originalInClause.exchange(orNode);
            orNode.setSubType(SQLLogical.SubType.OR);
            SQLIn newSQLINNode = (SQLIn)factory.createNode(301076);
            orNode.addChild(newSQLINNode);
            orNode.addChild(originalInClause);
            IXQEQueryNode testExpression = factory.deepCopyNode(originalInClause.getChild(0));
            newSQLINNode.addChild(testExpression);
            IXQEQueryNode newInList = factory.createNode(301030);
            newSQLINNode.addChild(newInList);
            for (int i = 0; i < maxLengthInClause; ++i) {
                inList.getChild(0).move(newInList);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        int maxLengthInClause = 0;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        SQLIn in = (SQLIn)node;
        boolean status = null != pQueryBlock && pQueryBlock.isForeign();
        Boolean hint = (Boolean)in.getHint(COLLAPSE_HINT);
        if (hint != null && hint.booleanValue()) {
            in.removeHint(COLLAPSE_HINT);
            return true;
        }
        if (status) {
            IDataSource datasource = pQueryBlock.getDataSource();
            IDataSourceCapabilities capabilities = datasource.getCapabilities();
            maxLengthInClause = capabilities.getIntegerValue("limits.maxLengthInClause", 0);
            if (maxLengthInClause == 0) {
                return false;
            }
            IXQEQueryNode inList = node.getChild(1);
            if (inList == null) {
                status = false;
            } else if (inList.getNumberChildren() <= maxLengthInClause) {
                status = false;
            }
            this.traceQueryCondition(status, "SQLIN contains more elements than the limit, needs to be split", trace);
        } else {
            this.traceQueryCondition(status, "SQLIN contains fewer elements than the max, no need to split.", trace);
        }
        return status;
    }

    public static final class DateHelper
    implements ComparisonHelper {
        DateValue nextDate = DataValueFactory.createDateValue();

        @Override
        public int compareToNext(IValue current, IValue o) {
            this.nextDate.copyFrom(current);
            this.nextDate.addDays(1);
            return this.nextDate.compareTo(o);
        }

        @Override
        public int compareTo(IValue prev, IValue current) {
            if (current.compareTo(prev) == 0) {
                return 0;
            }
            return -1;
        }
    }

    public static final class IntegerHelper
    implements ComparisonHelper {
        @Override
        public int compareToNext(IValue current, IValue toBeCompared) {
            long next;
            long l = ((ExactNumericValue)toBeCompared).getLong();
            if (l == (next = ((ExactNumericValue)current).getLong() + 1L)) {
                return 0;
            }
            if (l > next) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compareTo(IValue prev, IValue current) {
            long pValue;
            long cValue = ((ExactNumericValue)current).getLong();
            if (cValue == (pValue = ((ExactNumericValue)prev).getLong())) {
                return 0;
            }
            return -1;
        }
    }

    public static interface ComparisonHelper {
        public int compareToNext(IValue var1, IValue var2);

        public int compareTo(IValue var1, IValue var2);
    }
}

