/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLIsDistinctFrom;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.optimization.util.SelectivityEstimator;

public final class FactorAnalyzer {
    public static void analyze(SQLFilter factor) {
        SQLExpression predicate = factor.getPredicate();
        int lSourceNo = -1;
        int rSourceNo = -1;
        double selectivity = 1.0;
        factor.setIncidence(predicate.incidence(new BitMask()));
        FactorType type = FactorType.COMPLEX;
        boolean isCorrelated = false;
        if (predicate.getType() == 301026 || predicate.getType() == 301075 && ((SQLIsDistinctFrom)predicate).isNegated()) {
            IXQEQueryNode left = predicate.getChild(0);
            IXQEQueryNode right = predicate.getChild(1);
            SQLComparison.SubType subType = predicate.getType() == 301075 ? SQLComparison.SubType.EQUAL : ((SQLComparison)predicate).getSubType();
            isCorrelated = left.getType() == 301082 || right.getType() == 301082;
            switch (subType) {
                case EQUAL: {
                    IXQEQueryNode aaSide = null;
                    IXQEQueryNode bbSide = null;
                    if (left.getType() == 301032 || left.getType() == 301082) {
                        aaSide = left;
                        bbSide = right;
                    } else if (right.getType() == 301032 || right.getType() == 301082) {
                        aaSide = right;
                        bbSide = left;
                    }
                    if (aaSide == null) break;
                    lSourceNo = ((SQLFid)aaSide).getSourceNo();
                    if (bbSide.getType() == 301032 || bbSide.getType() == 301082) {
                        rSourceNo = ((SQLFid)bbSide).getSourceNo();
                        if (aaSide.getType() == 301032 && bbSide.getType() == 301032 && lSourceNo == rSourceNo) {
                            type = FactorType.LEFT_OR_RIGHT_COL;
                            selectivity = SelectivityEstimator.equalColumn((SQLFid)aaSide, (SQLFid)bbSide);
                            break;
                        }
                        type = FactorType.EQUIJOIN;
                        selectivity = SelectivityEstimator.equalExpression((SQLFid)aaSide);
                        break;
                    }
                    type = FactorType.EQUIEXPRESSION;
                    selectivity = SelectivityEstimator.equalExpression((SQLFid)aaSide);
                    break;
                }
                case LESS: 
                case LESSEQUAL: 
                case GREATER: 
                case GREATEREQUAL: {
                    SQLFid aSide = null;
                    IXQEQueryNode bSide = null;
                    if (left.getType() == 301032) {
                        aSide = (SQLFid)left;
                        bSide = right;
                    } else if (right.getType() == 301032) {
                        aSide = (SQLFid)right;
                        bSide = left;
                    }
                    if (aSide == null) break;
                    lSourceNo = aSide.getSourceNo();
                    if (bSide.getType() == 301032) {
                        rSourceNo = ((SQLFid)bSide).getSourceNo();
                        if (lSourceNo == rSourceNo) {
                            type = FactorType.LEFT_OR_RIGHT_COL;
                            selectivity = SelectivityEstimator.equalColumn(aSide, (SQLFid)bSide);
                            break;
                        }
                        type = FactorType.THETAJOIN;
                        selectivity = SelectivityEstimator.equalExpression(aSide);
                        break;
                    }
                    type = subType == SQLComparison.SubType.LESS || subType == SQLComparison.SubType.LESSEQUAL ? FactorType.LESSEXPRESSION : FactorType.GREATEREXPRESSION;
                    selectivity = SelectivityEstimator.getSelectivity(predicate);
                    break;
                }
            }
        }
        factor.setFactorType(type);
        factor.setLeftSourceNo(lSourceNo);
        factor.setRightSourceNo(rSourceNo);
        factor.setSelectivity(selectivity);
        factor.setCorrelated(isCorrelated);
    }

    public static void analyze(SQLFilter factor, int subType) {
        FactorAnalyzer.analyze(factor);
        factor.setSubType(subType);
    }

    public static enum FactorType {
        EQUIJOIN,
        EQUIEXPRESSION,
        LESSEXPRESSION,
        GREATEREXPRESSION,
        THETAJOIN,
        COMPLEX,
        LEFT_OR_RIGHT_COL;

    }
}

