/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization.vqe;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.SQLValueDecoration;
import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashSet;

public final class VectorizeSQLBetween
extends RQETransformation {
    private static final HashSet<String> NOT_GENERATED_VECTOR_CLASSES = new HashSet();

    public VectorizeSQLBetween() {
        this.mName = "Vectorize BETWEEN expression.";
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{301045};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode[] children = node.getChildren();
        IXQEQueryNode parent = node.getParent();
        boolean notBetween = false;
        if (parent.getType() == 301027 && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.NOT) {
            parent.getParent().exchangeChildNode(parent, node, false);
            notBetween = true;
        }
        SQLComparison cmpNode1 = (SQLComparison)factory.createNode(301026);
        if (notBetween) {
            cmpNode1.setSubType(SQLComparison.SubType.LESS);
        } else {
            cmpNode1.setSubType(SQLComparison.SubType.GREATEREQUAL);
        }
        cmpNode1.addChild(factory.deepCopyNode(children[0]));
        children[1].move(cmpNode1);
        SQLComparison cmpNode2 = (SQLComparison)factory.createNode(301026);
        if (notBetween) {
            cmpNode2.setSubType(SQLComparison.SubType.GREATER);
        } else {
            cmpNode2.setSubType(SQLComparison.SubType.LESSEQUAL);
        }
        children[0].move(cmpNode2);
        children[2].move(cmpNode2);
        SQLLogical logicalNode = (SQLLogical)factory.createNode(301027);
        if (notBetween) {
            logicalNode.setSubType(SQLLogical.SubType.OR);
        } else {
            logicalNode.setSubType(SQLLogical.SubType.AND);
        }
        logicalNode.addChild(cmpNode1);
        logicalNode.addChild(cmpNode2);
        node.exchange(logicalNode);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLValueDecoration valueDecorationNode = (SQLValueDecoration)node.getAncestorOfType(601013);
        boolean bl = status = valueDecorationNode != null && valueDecorationNode.isVectorizedQueryExecutionEnabled();
        if (status) {
            this.traceQueryCondition(status, "Vectorized query execution is applicable.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized query execution is not applicable.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        SQLQueryNode child0 = (SQLQueryNode)node.getChild(0);
        SQLQueryNode child1 = (SQLQueryNode)node.getChild(1);
        SQLQueryNode child2 = (SQLQueryNode)node.getChild(2);
        boolean bl = status = !(qBlock != null && qBlock.isForeign() || child1.getType() == 301031 && child2.getType() == 301031 && !this.requiredDataType(child0.getDataType()) && !this.requiredDataType(child1.getDataType()) && !this.requiredDataType(child2.getDataType()) && !this.vectorClassNotGenerated(node));
        if (status) {
            this.traceQueryCondition(status, "BETWEEN predicate needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "BETWEEN predicate does not need to be converted.", trace);
        }
        return status;
    }

    private boolean requiredDataType(IDataType dataType) {
        return dataType.isTime() || dataType.isTimestamp() || dataType.isInterval();
    }

    private boolean vectorClassNotGenerated(IXQEQueryNode node) {
        String className = ((SQLBetween)node).getVectorClassName();
        return NOT_GENERATED_VECTOR_CLASSES.contains(className);
    }

    static {
        NOT_GENERATED_VECTOR_CLASSES.add("com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorDecimalColumnBetween");
        NOT_GENERATED_VECTOR_CLASSES.add("com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorDecimalColumnNotBetween");
    }
}

