/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.util.SQLPlainQueryFormatter;
import com.cognos.xqe.data.providers.relational.SQLCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class AddNotes
extends RQETransformation {
    private static Boolean enabledInConfig = null;

    public AddNotes() {
        this.mName = "Generate node notes.";
        this.mPassNumbers = new int[]{27};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mTypes = new int[]{301019, 301015, 301010, 301029, 301009, 301034, 301033, 301025, 301027, 301026, 301045, 301071, 301072, 301073, 301074, 301044, 301047};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLCapabilities capabilities = SQLCapabilities.getInstance();
        SQLQueryNode qNode = (SQLQueryNode)node;
        SQLPlainQueryFormatter qFormatter = new SQLPlainQueryFormatter();
        qNode.getCognosSQL(capabilities, qFormatter);
        qNode.setPropertyValue("note", ((QueryFormatter)qFormatter).getBuffer());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = this.notesEnabledInConfig(environment) && !((SQLQueryNode)node).getParentQueryBlock().isForeign() && node.getPropertyValue("note") == null;
        if (status) {
            this.traceQueryCondition(status, "Note can be added.", trace);
        } else {
            this.traceQueryCondition(status, "Note cannot be added.", trace);
        }
        return status;
    }

    private boolean notesEnabledInConfig(IPlanningEnvironment environment) {
        if (enabledInConfig == null) {
            MultiRequestContext multiRequestContext = environment.getMultiRequestContext();
            boolean enabled = multiRequestContext.fetchBooleanConfiguration("queryPlanning[@traceEnabled]", false) && multiRequestContext.fetchBooleanConfiguration("queryPlanning.notes[@enabled]", Boolean.FALSE);
            enabledInConfig = enabled;
        }
        return enabledInConfig;
    }
}

