/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.SmallintValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class AvoidDivisionByZero
extends RQETransformation {
    public AvoidDivisionByZero() {
        this.mName = "Avoid division by zero.";
        this.mPassNumbers = new int[]{24};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mTypes = new int[]{301025, 301033};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        if (pQueryBlock == null || pQueryBlock.isForeign()) {
            XQENodeFactory factory = environment.getNodeFactory();
            IXQEQueryNode nullif = factory.createNode(301071);
            IXQEQueryNode denominator = node.getChild(1);
            denominator.insertParent(nullif);
            SmallintValue sValue = DataValueFactory.createSmallintValue();
            sValue.set(0);
            SQLLiteral literal = (SQLLiteral)factory.createNode(301031);
            literal.setValue(sValue);
            nullif.addChild(literal);
            ((SQLQueryNode)node).invalidateSupportCache();
        } else if (node.getType() == 301025) {
            ((SQLValueExpression)node).setSubType(SQLValueExpression.SubType.SAFE_DIVIDE);
        } else {
            ((SQLFunction)node).setSubType(SQLFunction.SubType.SAFE_MOD);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        Governors governors = node.getGovernors();
        boolean bl = status = governors != null && governors.getAvoidDivisionZero() != false;
        if (status) {
            if (node.getType() == 301025) {
                status = ((SQLValueExpression)node).getSubType() == SQLValueExpression.SubType.DIVIDE;
            } else {
                boolean bl2 = status = ((SQLFunction)node).getSubType() == SQLFunction.SubType.MOD;
            }
        }
        if (status) {
            status &= !this.alreadyAvoidedDivByZero(node.getChild(1));
        }
        if (status) {
            this.traceQueryCondition(status, "Division by zero is possible.", trace);
        } else {
            this.traceQueryCondition(status, "Division by zero is not possible.", trace);
        }
        return status;
    }

    private boolean alreadyAvoidedDivByZero(IXQEQueryNode node) {
        boolean avoided = false;
        if (node.getType() == 301025 && ((SQLValueExpression)node).getSubType() == SQLValueExpression.SubType.NEGATE && node.getChild(0).getType() == 301031) {
            avoided = !this.isZeroLiteral(node.getChild(0));
        } else if (node.getType() == 301031) {
            avoided = !this.isZeroLiteral(node);
        } else if (node.getType() == 301071) {
            avoided = this.isZeroLiteral(node.getChild(1));
        } else if (node.getType() == 301074) {
            for (int i = 0; i < node.getNumberChildren() && !avoided; ++i) {
                IXQEQueryNode child = node.getChild(i);
                if (child.getType() != 301048 || child.getChild(0).getType() != 301026 || ((SQLComparison)child.getChild(0)).getSubType() != SQLComparison.SubType.EQUAL) continue;
                avoided = this.isZeroLiteral(child.getChild(0).getChild(1)) && child.getChild(1).getType() == 301050;
            }
        }
        return avoided;
    }

    private boolean isZeroLiteral(IXQEQueryNode node) {
        if (node.getType() == 301031) {
            Value value = ((SQLLiteral)node).getValue();
            return value.isNumeric() && ((NumericValue)value).isZero();
        }
        return false;
    }
}

