/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ConvertFDSCastFunctionToCompatibleSQL
extends RQETransformation {
    private static final int MAXARGUMENTS = 3;
    private static final int TIME_LITERAL_LENGTH = 8;
    private static final int DATE_LITERAL_LENGTH = 10;
    private static final int TIMETZ_LITERAL_LENGTH = 14;
    private static final int TIMESTAMPTZ_LITERAL_LENGTH = 35;
    private static final int TIMESTAMP_LITERAL_LENGTH = 23;
    private static final int DEFAULT_PRECISION = 200;
    private static final String CASTUNDERSCORE = "CAST_";

    public ConvertFDSCastFunctionToCompatibleSQL() {
        this.mName = "Convert FDS's cast_<data type> function to Standard SQL";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301033};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        IDataSource dataSource;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        String castFunctionName = ((SQLFunction)node).getSQLFunctionName();
        String upperCaseCastFunctionName = castFunctionName.toUpperCase();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        if (pQueryBlock != null && (dataSource = pQueryBlock.getDataSource()) != null) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            if (upperCaseCastFunctionName.startsWith(CASTUNDERSCORE)) {
                FDSCastFunctions fds = FDSCastFunctions.valueOf(upperCaseCastFunctionName);
                boolean bl = status = fds.toString() != null && !SQLFunction.isFeatureSupported(capabilities, castFunctionName, ((SQLFunction)node).getParameterTypes());
            }
        }
        if (status) {
            this.traceQueryCondition(status, castFunctionName + " function needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, castFunctionName + " function does not need to be converted.", trace);
        }
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        int children = node.getNumberChildren();
        SQLQueryNode operandNode = (SQLQueryNode)node.getChild(0);
        IDataType dataType = operandNode.getDataType();
        SQLCast castNode = (SQLCast)factory.createNode(301047);
        SQLDataType dType = (SQLDataType)factory.createNode(301037);
        String castFunctionName = ((SQLFunction)node).getSQLFunctionName();
        FDSCastFunctions fds = FDSCastFunctions.valueOf(castFunctionName.toUpperCase());
        block0 : switch (fds) {
            case CAST_VARCHAR: 
            case CAST_LONGVARCHAR: {
                switch (children) {
                    case 1: {
                        if (dataType.getCCLTypeCode() == 107) {
                            dType.setDataType(DataTypeFactory.getVarcharType(1));
                            break block0;
                        }
                        dType.setDataType(DataTypeFactory.getVarcharType(200));
                        break block0;
                    }
                    case 2: {
                        dType.setDataType(DataTypeFactory.getVarcharType(((SQLLiteral)node.getChild(1)).getValue().getInteger()));
                        node.getChild(1).extract();
                        break block0;
                    }
                }
                break;
            }
            case CAST_CHAR: {
                switch (children) {
                    case 1: {
                        if (dataType.getCCLTypeCode() == 107) {
                            dType.setDataType(DataTypeFactory.getCharType(1));
                            break block0;
                        }
                        if (dataType.isDate()) {
                            dType.setDataType(DataTypeFactory.getCharType(10));
                            break block0;
                        }
                        if (dataType.getCCLTypeCode() == 58) {
                            dType.setDataType(DataTypeFactory.getCharType(8));
                            break block0;
                        }
                        if (dataType.getCCLTypeCode() == 52) {
                            dType.setDataType(DataTypeFactory.getCharType(14));
                            break block0;
                        }
                        if (dataType.getCCLTypeCode() == 59) {
                            dType.setDataType(DataTypeFactory.getCharType(23));
                            break block0;
                        }
                        if (dataType.getCCLTypeCode() == 53) {
                            dType.setDataType(DataTypeFactory.getCharType(35));
                            break block0;
                        }
                        dType.setDataType(DataTypeFactory.getCharType(dataType.getPrecision()));
                        break block0;
                    }
                    case 2: {
                        dType.setDataType(DataTypeFactory.getCharType(((SQLLiteral)node.getChild(1)).getValue().getInteger()));
                        node.getChild(1).extract();
                        break block0;
                    }
                }
                break;
            }
            case CAST_DATE: {
                dType.setDataType(DataTypeFactory.getDateType());
                break;
            }
            case CAST_TIME: {
                switch (children) {
                    case 1: {
                        dType.setDataType(DataTypeFactory.getTimeType());
                        break block0;
                    }
                    case 2: {
                        dType.setDataType(DataTypeFactory.getTimeType(((SQLLiteral)node.getChild(1)).getValue().getInteger()));
                        node.getChild(1).extract();
                        break block0;
                    }
                }
                break;
            }
            case CAST_TIMESTAMP: {
                switch (children) {
                    case 1: {
                        dType.setDataType(DataTypeFactory.getTimestampType());
                        break block0;
                    }
                    case 2: {
                        dType.setDataType(DataTypeFactory.getTimestampType(((SQLLiteral)node.getChild(1)).getValue().getInteger()));
                        node.getChild(1).extract();
                        break block0;
                    }
                }
                break;
            }
            case CAST_INTEGER: {
                int iScale = dataType.getCCLTypeCode() == 45 ? 0 : dataType.getScale();
                dType.setDataType(DataTypeFactory.getIntegerType(iScale));
                break;
            }
            case CAST_SMALLINT: {
                dType.setDataType(DataTypeFactory.getSmallintType());
                break;
            }
            case CAST_DOUBLE: 
            case CAST_DOUBLE_PRECISION: {
                dType.setDataType(DataTypeFactory.getDoubleType());
                break;
            }
            case CAST_FLOAT: 
            case CAST_REAL: {
                dType.setDataType(DataTypeFactory.getFloatType());
                break;
            }
            case CAST_DECIMAL: 
            case CAST_NUMERIC: {
                switch (children) {
                    case 1: {
                        int nScale;
                        int nPrecision;
                        if (dataType.getCCLTypeCode() == 107) {
                            nPrecision = 1;
                            nScale = 0;
                        } else if (dataType.getCCLTypeCode() == 45) {
                            nPrecision = dataType.getPrecision();
                            nScale = 0;
                        } else {
                            nPrecision = dataType.getPrecision();
                            nScale = dataType.getScale();
                        }
                        nPrecision = this.adjustDecimalPrecisionForVendor(operandNode, nPrecision);
                        dType.setDataType(DataTypeFactory.getDecimalType(nPrecision, nScale));
                        break;
                    }
                    case 2: {
                        int nPrecision = ((SQLLiteral)node.getChild(1)).getValue().getInteger();
                        dType.setDataType(DataTypeFactory.getDecimalType(nPrecision));
                        node.getChild(1).extract();
                        break;
                    }
                    case 3: {
                        int nPrecision = ((SQLLiteral)node.getChild(1)).getValue().getInteger();
                        int nScale = ((SQLLiteral)node.getChild(2)).getValue().getInteger();
                        dType.setDataType(DataTypeFactory.getDecimalType(nPrecision, nScale));
                        for (int i = 1; i < children; ++i) {
                            node.getChild(1).extract();
                        }
                        break block0;
                    }
                }
                break;
            }
            case CAST_NUMBERTOSTRING: {
                dType.setDataType(DataTypeFactory.getCharType(dataType.getPrecision()));
                break;
            }
        }
        operandNode.move(castNode);
        castNode.addChild(dType);
        node.exchange(castNode);
    }

    private int adjustDecimalPrecisionForVendor(SQLQueryNode operand, int precision) {
        int adjustedPrecision = precision;
        SQLQueryBlock qBlock = (SQLQueryBlock)operand.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        if (dataSource != null && dataSource.getCapabilities() != null) {
            try {
                int maxDecimalPrecision = dataSource.getCapabilities().getIntegerValue("limits.maxDecimalPrecision");
                if (adjustedPrecision > maxDecimalPrecision) {
                    adjustedPrecision = maxDecimalPrecision;
                }
            }
            catch (XQERuntimeException xQERuntimeException) {
                // empty catch block
            }
        }
        return adjustedPrecision;
    }

    public static enum FDSCastFunctions {
        CAST_VARCHAR,
        CAST_LONGVARCHAR,
        CAST_CHAR,
        CAST_TIME,
        CAST_TIMESTAMP,
        CAST_INTEGER,
        CAST_DATE,
        CAST_SMALLINT,
        CAST_DOUBLE,
        CAST_DOUBLE_PRECISION,
        CAST_FLOAT,
        CAST_DECIMAL,
        CAST_REAL,
        CAST_NUMERIC,
        CAST_NUMBERTOSTRING;

    }
}

