/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public final class ConvertRowNumber
extends RQETransformation {
    public ConvertRowNumber() {
        this.mName = "Convert ROW_NUMBER aggregate.";
        this.mPassNumbers = new int[]{24};
        this.mTypes = new int[]{301034};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLAggregate shapeshifter = (SQLAggregate)node;
        shapeshifter.setSubType(SQLAggregate.SubType.SUM);
        SQLLiteral literal = (SQLLiteral)nodeFactory.createNode(301031);
        literal.setDataType(IntegerType.INTEGERTYPE);
        literal.setValue("1");
        shapeshifter.addChild(literal, 0);
        IXQEQueryNode[] windows = shapeshifter.getChildrenOfType(301041);
        SQLWindow window = (SQLWindow)windows[0];
        window.setWindowFrameLowerBound(Integer.MIN_VALUE);
        window.setWindowFrameUpperBound(0);
        window.setWindowFrameUnits("ROWS");
        shapeshifter.invalidateSupportCache();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLAggregate sqlNode = (SQLAggregate)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = pQueryBlock.isForeign() && sqlNode.getSubType() == SQLAggregate.SubType.ROW_NUMBER && !SQLAggregate.isOlapFeatureSupported(pQueryBlock.getDataSource().getCapabilities(), SQLAggregate.SubType.ROW_NUMBER, sqlNode.getNumberParameters());
        if (status) {
            this.traceQueryCondition(status, "ROW_NUMBER aggregate needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "ROW_NUMBER aggregate doesn't need to be converted.", trace);
        }
        return status;
    }
}

