/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLCoalesce;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSearchedCase;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWhen;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public final class ConvertSQLCoalesce
extends RQETransformation {
    public ConvertSQLCoalesce() {
        this.mName = "Convert COALESCE expression.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301072};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLValueList oldValueListNode = (SQLValueList)node.getChild(0);
        if (oldValueListNode.getNumberChildren() == 1) {
            node.exchange(oldValueListNode.getChild(0));
            return;
        }
        XQENodeFactory factory = environment.getNodeFactory();
        SQLSearchedCase searchedCaseNode = (SQLSearchedCase)factory.createNode(301074);
        SQLValueList newValueListNode = (SQLValueList)factory.createNode(301030);
        searchedCaseNode.addChild(newValueListNode);
        SQLQueryNode savedLastChild = (SQLQueryNode)oldValueListNode.detachChild(oldValueListNode.getNumberChildren() - 1);
        IXQEQueryNode[] children = oldValueListNode.getChildren();
        newValueListNode.addChildren(children, 0);
        node.detachChildren();
        for (int i = 0; i < children.length; ++i) {
            SQLQueryNode currentChild = (SQLQueryNode)newValueListNode.getChild(i);
            SQLWhen whenNode = (SQLWhen)factory.createNode(301048);
            currentChild.exchange(whenNode);
            SQLLogical logicalNode = (SQLLogical)factory.createNode(301027);
            logicalNode.setSubType(SQLLogical.SubType.NOT);
            whenNode.addChild(logicalNode);
            SQLIsNull isNullNode = (SQLIsNull)factory.createNode(301024);
            logicalNode.addChild(isNullNode);
            isNullNode.addChild(currentChild);
            SQLQueryNode thenNode = (SQLQueryNode)factory.deepCopyNode(currentChild);
            whenNode.addChild(thenNode);
        }
        searchedCaseNode.addChild(savedLastChild);
        node.exchange(searchedCaseNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean status = false;
        if (dataSource != null) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            int minArgs = capabilities.getIntegerValue("expressions.Coalesce.minArgs", 0);
            boolean bl = status = pQueryBlock.isForeign() && SQLSearchedCase.isFeatureSupported(capabilities) && (!SQLCoalesce.isFeatureSupported(capabilities) || minArgs > 0 && ((SQLCoalesce)node).getNumberParameters() < minArgs);
        }
        if (status) {
            this.traceQueryCondition(status, "COALESCE expression needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "COALESCE expression doesn't need to be converted.", trace);
        }
        return status;
    }
}

