/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ConvertSummaryFilter
extends RQETransformation {
    static final String DERIVED_TABLE_NAME = "D1";

    public ConvertSummaryFilter() {
        this.mName = "Convert Summary Filter";
        this.mPassNumbers = new int[]{3};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mTypes = new int[]{301053};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
        IDataSource dataSource = pQueryBlock.getDataSource();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryNode predicate = (SQLQueryNode)node.getChild(1);
        List<IXQEQueryNode> filterAggr = predicate.getDescendantsOfTypeOrdered(301034, false);
        List<IXQEQueryNode> filterExpr = predicate.getProjectableExpressionsIncludingAnchorList(dataSource, filterAggr);
        ArrayList<IXQEQueryNode> pushAggr = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> dontPushAggr = new ArrayList<IXQEQueryNode>();
        SQLProject project = (SQLProject)node.getParent();
        SQLValueList vList = (SQLValueList)project.getChild(1);
        IXQEQueryNode[] aggregates = vList.getDescendantsOfType(301034, true);
        for (int i = 0; i < aggregates.length; ++i) {
            SQLWindow window = (SQLWindow)aggregates[i].getFirstChildByType(301041);
            if (window != null && window.isPrefilter()) {
                pushAggr.add(aggregates[i]);
                window.setPrefilter(false);
                continue;
            }
            dontPushAggr.add(aggregates[i]);
        }
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        qBlock.setForeign(true);
        qBlock.setName(DERIVED_TABLE_NAME);
        qBlock.setDataSourceList(dataSources);
        node.getChild(0).insertParent(qBlock);
        SQLProject derived = (SQLProject)nodeFactory.createNode(301015);
        qBlock.getChild(0).insertParent(derived);
        List<IXQEQueryNode> exprList = vList.getProjectableExpressions(dataSource, pushAggr, dontPushAggr);
        exprList.addAll(filterExpr);
        SQLValueList derivedProjection = SQLPreoptimizerUtil.buildProjection(environment, exprList, 0, 0, dataSource);
        derived.addChild(derivedProjection);
        qBlock.setQueryItemList(SQLPreoptimizerUtil.getQueryItemList(derivedProjection));
        ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
        for (int i = 0; i < derivedProjection.getNumberChildren(); ++i) {
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName("C" + i);
            aliasList.add(aliasNode);
        }
        derivedProjection.setAliasList(aliasList);
        List<SQLAlias> outerAliasList = vList.getAliasList();
        if (outerAliasList == null) {
            outerAliasList = new ArrayList<SQLAlias>(vList.getNumberChildren());
            vList.setAliasList(outerAliasList);
        }
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            SQLAlias aliasNode;
            IXQEQueryNode child = vList.getChild(i);
            if (child.getType() != 301032 || (aliasNode = outerAliasList.get(((SQLFid)child).getColumnNo())) != null) continue;
            aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName(((SQLFid)child).getName());
            outerAliasList.set(((SQLFid)child).getColumnNo(), aliasNode);
        }
        List<SQLFid> fids = project.getFieldIdentifiers();
        for (int i = 0; i < fids.size(); ++i) {
            SQLFid fid = fids.get(i);
            fid.setName(((SQLAlias)aliasList.get(fid.getColumnNo())).getName());
            fid.setTableName(DERIVED_TABLE_NAME);
        }
        SQLFilter filter = (SQLFilter)nodeFactory.createNode(301009);
        node.exchange(filter, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode[] aggregates;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getParent().getType() == 301010) {
            return status;
        }
        IXQEQueryNode project = node.getAncestorOfType(301015);
        if (project != null) {
            IXQEQueryNode[] windows = project.getChild(1).getDescendantsOfType(301041, false);
            for (int i = 0; i < windows.length; ++i) {
                if (!((SQLWindow)windows[i]).isPrefilter()) continue;
                status = true;
                break;
            }
        }
        if (!status && (aggregates = node.getChild(1).getDescendantsOfType(301034, false)).length > 0) {
            status = true;
        }
        if (status) {
            this.traceQueryCondition(status, "The query contains summary filter.", trace);
        } else {
            this.traceQueryCondition(status, "The query doesn't contain summary filter.", trace);
        }
        return status;
    }
}

