/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqe.transformation.relational.optimization.util.JoinMatrix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CreateSemiJoinWithInPredicate
extends RQETransformation {
    public CreateSemiJoinWithInPredicate() {
        this.mName = "Create a semi-join query.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{301014};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        ArrayList<SQLFilter> factorList = new ArrayList<SQLFilter>();
        IXQEQueryNode parent = node.getParent();
        while (parent.getType() == 301009) {
            factorList.add(0, (SQLFilter)parent);
            parent = parent.getParent();
        }
        BitMask sjMask = this.getSemiJoinMask(qBlock, node);
        IXQEQueryNode[] children = node.getChildren();
        for (int sourceNo = 0; sourceNo < children.length; ++sourceNo) {
            if (!sjMask.get(sourceNo)) continue;
            SQLFilter filterNode = (SQLFilter)nodeFactory.createNode(301009);
            node.insertParent(filterNode);
            SQLIn inNode = (SQLIn)nodeFactory.createNode(301076);
            filterNode.addChild(inNode);
            IXQEQueryNode rowConstructor = nodeFactory.createNode(301040);
            inNode.addChild(rowConstructor, 0);
            IXQEQueryNode subQuery = nodeFactory.createNode(301059);
            inNode.addChild(subQuery);
            SQLQueryBlock qBlock2 = (SQLQueryBlock)nodeFactory.createNode(301004);
            subQuery.addChild(qBlock2);
            SQLQueryNode child = (SQLQueryNode)children[sourceNo].detach();
            qBlock2.setDataSource(child.getDataSource());
            IXQEQueryNode projNode = nodeFactory.createNode(301015);
            qBlock2.addChild(projNode);
            projNode.addChild(child);
            IXQEQueryNode valueList = nodeFactory.createNode(301030);
            projNode.addChild(valueList);
            Iterator fIterator = factorList.iterator();
            while (fIterator.hasNext()) {
                SQLFilter factor = (SQLFilter)fIterator.next();
                BitMask fIncidence = factor.getIncidence();
                if (!fIncidence.get(sourceNo)) continue;
                SQLQueryNode predicate = (SQLQueryNode)factor.getPredicate().detach();
                factor.extract();
                if (fIncidence.cardinality() == 1) {
                    projNode.getChild(0).insertParent(factor);
                    factor.addChild(predicate);
                } else {
                    List<SQLFid> fidList = predicate.getFieldIdentifiers();
                    for (SQLFid fid : fidList) {
                        if (fid.getSourceNo() != sourceNo) {
                            rowConstructor.addChild(fid);
                            continue;
                        }
                        fid.setSourceNo(0);
                        fid.setVirtualColumnNo(fid.getColumnNo());
                        valueList.addChild(fid);
                    }
                }
                fIterator.remove();
            }
            FactorAnalyzer.analyze(filterNode);
            qBlock2.setForeign(projNode.isSupported(qBlock2.getDataSource()));
        }
        int nChildren = 0;
        int[] sourceMap = new int[children.length];
        for (int sourceNo = 0; sourceNo < children.length; ++sourceNo) {
            if (sjMask.get(sourceNo)) continue;
            sourceMap[sourceNo] = nChildren++;
        }
        int[] nColumns = new int[nChildren];
        for (int i = 0; i < nChildren; ++i) {
            nColumns[i] = ((SQLQueryNode)node.getChild(i)).getNumberColumns();
            if (i <= 0) continue;
            int n = i;
            nColumns[n] = nColumns[n] + nColumns[i - 1];
        }
        for (SQLFid fid : qBlock.getFieldIdentifiers()) {
            int sourceNo = sourceMap[fid.getSourceNo()];
            int vColumnNo = fid.getColumnNo();
            if (sourceNo > 0) {
                vColumnNo += nColumns[sourceNo - 1];
            }
            fid.setSourceNo(sourceNo);
            fid.setVirtualColumnNo(vColumnNo);
        }
        Iterator fIterator = factorList.iterator();
        while (fIterator.hasNext()) {
            FactorAnalyzer.analyze((SQLFilter)fIterator.next());
        }
        if (node.getNumberChildren() == 1) {
            SQLQueryNode child = (SQLQueryNode)node.getChild(0);
            node.extract();
            qBlock.setBlockType(301016);
            qBlock.setDataSource(child.getDataSource());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        Collection<IDataSource> dataSources = qBlock.getDataSourceList();
        boolean bl = status = dataSources.size() > 1 && qBlock.getParent().getType() == 301008 && qBlock.getChild(0).getType() == 301015 && qBlock.appliedTransitiveClosure() && this.getSemiJoinMask(qBlock, node).cardinality() > 0;
        if (status) {
            this.traceQueryCondition(status, "A semi-join query can be created.", trace);
        } else {
            this.traceQueryCondition(status, "A semi-join query cannot be created.", trace);
        }
        return status;
    }

    private BitMask getSemiJoinMask(SQLQueryBlock qBlock, IXQEQueryNode node) {
        int nChildren = node.getNumberChildren();
        SQLValueList outputList = ((SQLProject)qBlock.getChild(0)).getOutputList();
        BitMask pMask = outputList.incidence();
        BitMask result = new BitMask(nChildren);
        result.set(0, nChildren, true);
        result.xor(pMask);
        JoinMatrix jMask = new JoinMatrix(nChildren);
        IXQEQueryNode parent = node.getParent();
        while (parent.getType() == 301009) {
            SQLFilter factor = (SQLFilter)parent;
            BitMask fIncidence = factor.getIncidence();
            if (factor.getFactorType() == FactorAnalyzer.FactorType.EQUIJOIN) {
                jMask.set(factor.getLeftSourceNo(), factor.getRightSourceNo());
            } else if (fIncidence.cardinality() > 1) {
                result.andNot(fIncidence);
            }
            parent = parent.getParent();
        }
        for (int i = 0; i < nChildren; ++i) {
            if (jMask.get(i).cardinality() == 1) continue;
            result.clear(i);
        }
        return result;
    }
}

