/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLHaving;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class DecomposeSQLGroupByWithWindowedAggregates
extends RQETransformation {
    public static final String PROP_INTEGER_NCOLUMNS = "nColumns";

    public DecomposeSQLGroupByWithWindowedAggregates() {
        this.mName = "Decompose a SQLGroupBy node with windowed aggregates.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        DecomposeSQLGroupByWithWindowedAggregates.doTransformation(node, environment);
    }

    public static SQLQueryBlock doTransformation(IXQEQueryNode node, IPlanningEnvironment environment) {
        IDataSource dataSource;
        SQLGroupBy groupBy = (SQLGroupBy)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
        pQueryBlock.setForeign(false);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLGroupByList groupByList = groupBy.getGroupByList();
        SQLHaving havingNode = groupBy.getHavingClause();
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        qBlock.setDataSourceList(dataSources);
        qBlock.setForeign(false);
        Object noColumns = node.getChild(0).getPropertyValue(PROP_INTEGER_NCOLUMNS);
        if (noColumns != null) {
            qBlock.setNumberColumns((Integer)noColumns);
        }
        node.getChild(0).insertParent(qBlock);
        List<IXQEQueryNode> exprList = SQLPreoptimizerUtil.getProjectableExpressionsForGroupBy(groupBy.getOutputList());
        SQLValueList gValueList = SQLPreoptimizerUtil.buildProjection(environment, exprList, 0, 0, pQueryBlock.getDataSource());
        groupBy = (SQLGroupBy)nodeFactory.createNode(301010);
        qBlock.getChild(0).insertParent(groupBy);
        groupBy.addChild(gValueList);
        if (groupByList != null) {
            groupByList.move(groupBy);
        }
        if (havingNode != null) {
            havingNode.move(groupBy);
        }
        if ((dataSource = qBlock.getDataSource()) != null && groupBy.isSupported(dataSource)) {
            qBlock.setForeign(true);
        }
        SQLProject projNode = (SQLProject)nodeFactory.createNode(301015);
        node.exchange(projNode, true);
        return qBlock;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        boolean status = ((SQLQueryNode)node).getOutputList().hasWindowedAggregates();
        LinkedList<String> list = new LinkedList<String>();
        if (status && dataSource != null && dataSource.isRelational()) {
            boolean bl = status = !((SQLQueryNode)node).isSupported(dataSource, list);
        }
        if (status) {
            this.validateGroupByExpression(node, environment);
        }
        if (status) {
            this.traceQueryCondition(status, "GROUP BY with window functions is not supported." + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            this.traceQueryCondition(status, "GROUP BY operator with window functions is supported.", trace);
        }
        return status;
    }

    public void validateGroupByExpression(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLGroupBy groupBy = (SQLGroupBy)node;
        SQLValueList exprList = groupBy.getOutputList();
        SQLGroupByList groupByList = groupBy.getGroupByList();
        List<IXQEQueryNode> aggrs = exprList.getDescendantsOfTypeOrdered(301034, false);
        ArrayList<IXQEQueryNode> windowedAggrs = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> standardAggrs = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode aggr : aggrs) {
            if (((SQLAggregate)aggr).isWindowedAggregate()) {
                windowedAggrs.add(aggr);
                continue;
            }
            standardAggrs.add(aggr);
        }
        SQLIdentifier fid = null;
        for (int i = 0; i < windowedAggrs.size() && fid == null; ++i) {
            SQLAggregate windowedAggr = (SQLAggregate)windowedAggrs.get(i);
            List<IXQEQueryNode> fids = windowedAggr.getDescendantsOfTypeOrdered(301032, 301034);
            for (int j = 0; j < fids.size() && fid == null; ++j) {
                fid = (SQLFid)fids.get(j);
                for (int k = 0; k < standardAggrs.size() && fid != null; ++k) {
                    if (!fid.isAncestor((IXQEQueryNode)standardAggrs.get(k), 301034)) continue;
                    fid = null;
                }
                if (fid != null && groupByList != null && groupByList.indexOf(fid) != -1) {
                    fid = null;
                }
                if (fid == null || !fid.isAncestor(windowedAggr, 301034)) continue;
                fid = null;
            }
        }
        if (fid != null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedNonGroupedColumn, fid.getName());
        }
    }
}

