/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqe.util.CollectionCast;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class DecomposeSQLProduct
extends RQETransformation {
    public DecomposeSQLProduct() {
        this.mName = "Decompose a SQLProduct node.";
        this.mPassNumbers = new int[]{19};
        this.mTypes = new int[]{301014};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        View view = null;
        IDataSource dataSource = null;
        int nViews = 0;
        int nChildren = node.getNumberChildren();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        ArrayList<SQLFilter> factorList = new ArrayList<SQLFilter>();
        IXQEQueryNode parent = node.getParent();
        while (parent.getType() == 301009) {
            factorList.add(0, (SQLFilter)parent);
            parent = parent.getParent();
        }
        if (factorList.size() > 0) {
            pQueryBlock.setFactorList(factorList);
        }
        View[] distribution = new View[nChildren];
        BitSet sources = new BitSet();
        for (int sourceNo = 0; sourceNo < nChildren; ++sourceNo) {
            SQLQueryNode child = (SQLQueryNode)node.getChild(sourceNo);
            dataSource = child.getDataSource();
            if (dataSource != null && child.isSupported(dataSource)) {
                for (int k = 0; k < nViews; ++k) {
                    view = distribution[k];
                    if (view.getRoot() != null || !this.checkJoinCompatibility(view, factorList, sourceNo, dataSource)) continue;
                    view.addSource(sourceNo);
                    sources.set(sourceNo);
                    break;
                }
                if (sources.get(sourceNo)) continue;
                distribution[nViews++] = new View(dataSource, sourceNo);
                sources.set(sourceNo);
                continue;
            }
            if (sources.get(sourceNo)) continue;
            distribution[nViews++] = new View(dataSource, sourceNo, child);
            sources.set(sourceNo);
        }
        int nReqViews = nViews;
        for (int i = 0; i < nViews; ++i) {
            view = distribution[i];
            if (view.getIncidence().isEmpty() || view.getRoot() != null) continue;
            block4: for (int j = i + 1; j < nViews; ++j) {
                View tmpView = distribution[j];
                if (tmpView.getIncidence().isEmpty() || tmpView.getRoot() != null) continue;
                for (int k = 0; k < nChildren; ++k) {
                    if (!tmpView.getIncidence().get(k) || !this.checkJoinCompatibility(view, factorList, k, tmpView.getDataSource())) continue;
                    view.getIncidence().or(tmpView.getIncidence());
                    tmpView.getIncidence().clear();
                    --nReqViews;
                    continue block4;
                }
            }
        }
        int sourceNo = 0;
        int baseColumnNo = 0;
        IXQEQueryNode[] children = node.getChildren();
        if (nReqViews > 1) {
            for (int i = 0; i < nViews; ++i) {
                view = distribution[i];
                if (view.getIncidence().isEmpty()) continue;
                view.setSourceNo(sourceNo);
                view.setBaseColumnNo(baseColumnNo);
                if (view.getRoot() == null || view.getRoot().getType() == 301011) {
                    this.buildDerivedTable(environment, pQueryBlock, node, children, view, factorList);
                } else {
                    this.augmentDerivedTable(environment, pQueryBlock, view, factorList);
                }
                baseColumnNo += view.getNumberOfColumns();
                ++sourceNo;
            }
        }
        pQueryBlock.setForeign(false);
        pQueryBlock.setBlockType(301014);
        pQueryBlock.setMap(node.getChildren());
        if (factorList != null) {
            for (SQLFilter factor : factorList) {
                factor.setSubType(301011);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        LinkedList<String> list = new LinkedList<String>();
        Collection<IDataSource> dataSources = qBlock.getDataSourceList();
        IDataSource dataSource = qBlock.getDataSource();
        boolean bl = status = qBlock.getBlockType() != 301014 && (dataSource == null || dataSources.size() > 1 || !((SQLQueryNode)node).isSupported(dataSource, list));
        if (status) {
            this.traceQueryCondition(status, "Product node needs to be decomposed. " + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            this.traceQueryCondition(status, "Product node doesn't need to be decomposed.", trace);
        }
        return status;
    }

    private boolean checkJoinCompatibility(View view, List<SQLFilter> factorList, int sourceNo, IDataSource dataSource) {
        if (!(dataSource == null || view.getDataSource() == dataSource && view.getDataSource().getCapabilities().getBooleanValue("supports.crossProducts"))) {
            return false;
        }
        BitSet sMask = new BitSet();
        BitSet tMask = new BitSet();
        sMask.set(sourceNo);
        tMask.or(view.getIncidence());
        tMask.set(sourceNo);
        int nFactors = 0;
        BitSet tmpMask = new BitSet();
        for (SQLFilter factor : factorList) {
            if (!factor.getPredicate().isSupported(dataSource)) continue;
            BitMask fIncidence = factor.getIncidence();
            tmpMask.clear();
            tmpMask.or(tMask);
            tmpMask.and(fIncidence);
            if (!fIncidence.get(sourceNo) || fIncidence.equals(sMask) || !fIncidence.equals(tmpMask)) continue;
            ++nFactors;
        }
        return nFactors > 0;
    }

    private void buildDerivedTable(IPlanningEnvironment environment, SQLQueryBlock pQueryBlock, IXQEQueryNode root, IXQEQueryNode[] children, View view, List<SQLFilter> factorList) {
        IXQEQueryNode baseNode = null;
        boolean isLateral = false;
        BitMask vIncidence = view.getIncidence();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        int nChildren = vIncidence.cardinality();
        if (nChildren == 1) {
            baseNode = children[vIncidence.nextSetBit(0)];
            if (root.getPositionOfChild(baseNode) != view.getSourceNo()) {
                baseNode.move(root, view.getSourceNo());
            }
            if (baseNode.getType() == 301004) {
                isLateral = ((SQLQueryBlock)baseNode).isLateralDerivedTable();
            }
        } else {
            baseNode = nodeFactory.createNode(301014);
            root.addChild(baseNode, view.getSourceNo());
            for (int i = 0; i < children.length; ++i) {
                if (!vIncidence.get(i)) continue;
                children[i].move(baseNode);
            }
        }
        view.setRoot(baseNode);
        IDataSource dataSource = view.getDataSource();
        ArrayList<IDataSource> dsList = new ArrayList<IDataSource>();
        dsList.add(dataSource);
        if (factorList != null) {
            this.getApplicableFilters(environment, view, factorList, false);
        }
        BitMask incidence = new BitMask(vIncidence);
        ArrayList<SQLXid> xidList = new ArrayList<SQLXid>();
        List<IXQEQueryNode> tableFunctions = root.getDescendantsOfTypeOrdered(301038, false);
        for (int i = 0; i < tableFunctions.size(); ++i) {
            SQLXid xid;
            SQLTableFunction function = (SQLTableFunction)tableFunctions.get(i);
            if (function.getSubType() != SQLTableFunction.SubType.UNNEST || !incidence.get((xid = (SQLXid)function.getChild(1)).getSourceNo())) continue;
            incidence.set(i + 1);
            xidList.add(xid);
        }
        List<IXQEQueryNode> excludeList = pQueryBlock.getDescendantsOfTypeOrdered(301034, false);
        List<IXQEQueryNode> eNodeList = pQueryBlock.getProjectableExpressions(dataSource, SQLJoin.SubType.INNER, view.getSourceNo(), excludeList, root, vIncidence);
        SQLProject pNode = (SQLProject)nodeFactory.createNode(301015);
        view.getRoot().insertParent(pNode);
        SQLValueList vList = SQLPreoptimizerUtil.buildProjection(environment, eNodeList, incidence, view.getSourceNo(), view.getBaseColumnNo(), dataSource, pQueryBlock.getXidList());
        pNode.addChild(vList);
        SQLQueryItemList qItemList = ((SQLQueryNode)view.getRoot()).getQueryItemList();
        if (baseNode.getType() == 301011) {
            SQLPreoptimizerUtil.fixFieldIdentifiers(vList.getFieldIdentifiers(), qItemList);
        }
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        pNode.insertParent(qBlock);
        qBlock.setDataSourceList(dsList);
        qBlock.setForeign(true);
        qBlock.setNumberColumns(vList.getNumberChildren());
        qBlock.addXidList(xidList);
        qBlock.setLateral(isLateral);
        view.setRoot(qBlock);
        if (factorList != null) {
            this.getApplicableFilters(environment, view, factorList, true);
        }
        view.setNumberOfColumns(vList.getNumberChildren());
        qBlock.setQueryItemList(SQLPreoptimizerUtil.getQueryItemList(qItemList, vList));
    }

    private void augmentDerivedTable(IPlanningEnvironment environment, SQLQueryBlock pQueryBlock, View view, List<SQLFilter> factorList) {
        SQLQueryNode root = (SQLQueryNode)view.getRoot();
        IXQEQueryNode parent = root.getParent();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (root.getPositionOfChild(root) != view.getSourceNo()) {
            root.move(parent, view.getSourceNo());
        }
        if (factorList != null) {
            this.getApplicableFilters(environment, view, factorList, false);
        }
        if (view.getRoot() != root) {
            ArrayList<IDataSource> dsList = new ArrayList<IDataSource>();
            dsList.add(view.getDataSource());
            SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
            view.getRoot().insertParent(qBlock);
            qBlock.setDataSourceList(dsList);
            qBlock.setForeign(false);
            qBlock.setNumberColumns(root.getNumberColumns());
            qBlock.setQueryItemList(root.getQueryItemList());
            if (root.getType() == 301004) {
                qBlock.setLateral(((SQLQueryBlock)root).isLateralDerivedTable());
                ((SQLQueryBlock)root).setLateral(false);
            }
        }
        List<SQLFid> fidList = pQueryBlock.getFieldIdentifiers(parent, view.getIncidence());
        for (SQLFid fid : fidList) {
            fid.setSourceNo(view.getSourceNo());
            fid.setVirtualColumnNo(fid.getColumnNo() + view.getBaseColumnNo());
        }
        view.setNumberOfColumns(root.getNumberColumns());
    }

    private void getApplicableFilters(IPlanningEnvironment environment, View view, List<SQLFilter> factorList, boolean pushAlways) {
        SQLQueryNode baseNode = (SQLQueryNode)view.getRoot();
        IDataSource dataSource = view.getDataSource();
        IDataSourceCapabilities capabilities = null;
        if (dataSource != null) {
            capabilities = dataSource.getCapabilities();
        }
        BitSet mask = new BitSet();
        Iterator<SQLFilter> fIterator = factorList.iterator();
        while (fIterator.hasNext()) {
            SQLFilter factor = fIterator.next();
            BitMask fIncidence = factor.getIncidence();
            mask.clear();
            mask.or(view.getIncidence());
            mask.and(fIncidence);
            if (!mask.equals(fIncidence) || !pushAlways && capabilities != null && dataSource.isRelational() && !factor.getPredicate().isSupported(dataSource)) continue;
            SQLQueryNode predicate = (SQLQueryNode)factor.getPredicate().detach();
            baseNode.insertParent(factor.extract());
            baseNode = factor;
            factor.addChild(predicate);
            List<SQLFid> fidList = CollectionCast.downcast(predicate.getDescendantsOfTypeOrdered(301032, false), IXQEQueryNode.class, SQLFid.class);
            for (SQLFid fid : fidList) {
                fid.setSourceNo(0);
                fid.setVirtualColumnNo(fid.getColumnNo());
            }
            if (view.getRoot().getType() == 301011) {
                SQLPreoptimizerUtil.fixFieldIdentifiers(predicate.getFieldIdentifiers(), baseNode.getQueryItemList());
            }
            FactorAnalyzer.analyze(factor);
            fIterator.remove();
        }
        view.setRoot(baseNode);
    }

    private class View {
        private BitMask incidence = new BitMask();
        private IXQEQueryNode root;
        private IDataSource dataSource;
        private int sourceNo;
        private int baseColumnNo;
        private int nColumns;

        View(IDataSource theDataSource, int theSourceNo) {
            this.dataSource = theDataSource;
            this.incidence.set(theSourceNo);
        }

        View(IDataSource theDataSource, int theSourceNo, IXQEQueryNode theRoot) {
            this(theDataSource, theSourceNo);
            this.root = theRoot;
        }

        public void addSource(int theSourceNo) {
            this.incidence.set(theSourceNo);
        }

        public void setRoot(IXQEQueryNode theRoot) {
            this.root = theRoot;
        }

        public IXQEQueryNode getRoot() {
            return this.root;
        }

        public IDataSource getDataSource() {
            return this.dataSource;
        }

        public int getSourceNo() {
            return this.sourceNo;
        }

        public void setSourceNo(int theSourceNo) {
            this.sourceNo = theSourceNo;
        }

        public int getBaseColumnNo() {
            return this.baseColumnNo;
        }

        public void setBaseColumnNo(int theBaseColumnNo) {
            this.baseColumnNo = theBaseColumnNo;
        }

        public BitMask getIncidence() {
            return this.incidence;
        }

        public int getNumberOfColumns() {
            return this.nColumns;
        }

        public void setNumberOfColumns(int nCols) {
            this.nColumns = nCols;
        }
    }
}

