/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import java.util.List;

public final class DecomposeSQLSort
extends RQETransformation {
    protected static final String DECOMPOSE_SQL_SORT_APPLIED = "DecomposeSQLSortApplied";

    public DecomposeSQLSort() {
        this.mName = "Decompose a SQLSort node.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301019};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock parentQBlock = (SQLQueryBlock)node.getParent();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getChild(0);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSortKeyList sortKeyList = ((SQLSort)node).getSortKeyList();
        if ((sortKeyList = this.eliminateLiterals(sortKeyList)) == null) {
            return;
        }
        IXQEQueryNode child = node.getChild(0);
        if ((child = child.getChild(0)).getType() == 301022) {
            child = child.getChild(child.getNumberChildren() - 1);
        }
        while (child.getType() != 301015 && child.getType() != 301010) {
            child = child.getChild(0);
        }
        SQLProject projection = (SQLProject)child;
        SQLQueryItemList oldQueryItems = qBlock.getQueryItemList();
        SQLQueryItemList queryItems = oldQueryItems.copy();
        SQLValueList vList = projection.getOutputList();
        List<SQLAlias> aliasList = vList.getAliasList();
        int nColumns = vList.getNumberChildren();
        for (int i = 0; i < sortKeyList.getNumberChildren(); ++i) {
            SQLSortKey sortKey = (SQLSortKey)sortKeyList.getChild(i);
            SQLQueryNode sortKeyExpr = (SQLQueryNode)sortKey.getChild(0);
            if (!sortKey.isUnrelated() && sortKeyExpr.getType() == 301032) continue;
            sortKeyExpr.detach();
            int index = vList.indexOf(sortKeyExpr);
            if (index < 0) {
                index = vList.getNumberChildren();
                vList.addChild(sortKeyExpr);
                if (aliasList != null) {
                    aliasList.add(null);
                }
                SQLPreoptimizerUtil.addQueryItem(queryItems, sortKeyExpr);
            }
            SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
            fid.setVirtualColumnNo(index);
            fid.setDataType(sortKeyExpr.getDataType());
            sortKey.addChild(fid);
            sortKey.setUnrelated(false);
        }
        parentQBlock.setQueryItemList(queryItems);
        parentQBlock.setNumberColumns(vList.getNumberColumns());
        parentQBlock.setForeign(false);
        qBlock.setQueryItemList(queryItems);
        qBlock.setNumberColumns(vList.getNumberColumns());
        if (vList.getNumberChildren() != nColumns) {
            projection = (SQLProject)nodeFactory.createNode(301015);
            node.getParent().insertParent(projection);
            SQLValueList outputList = (SQLValueList)nodeFactory.createNode(301030);
            outputList.setAliasList(vList.getAliasList());
            projection.addChild(outputList);
            for (int i = 0; i < vList.getNumberChildren(); ++i) {
                SQLQueryItem qItem = (SQLQueryItem)queryItems.get(i);
                SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
                fid.setVirtualColumnNo(i);
                fid.setDataType(qItem.getDataType());
                outputList.addChild(fid);
            }
            SQLQueryBlock pQueryBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
            pQueryBlock.setForeign(false);
            pQueryBlock.setDataSourceList(qBlock.getDataSourceList());
            pQueryBlock.setQueryItemList(oldQueryItems);
            projection.insertParent(pQueryBlock);
        }
        node.setPropertyValue(DECOMPOSE_SQL_SORT_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        if (node.getPropertyValue(DECOMPOSE_SQL_SORT_APPLIED) == Boolean.TRUE) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean childSupported = true;
        boolean checkedChildSupport = false;
        boolean status = false;
        IXQEQueryNode child = node.getChild(0);
        if ((child = child.getChild(0)).getType() == 301022) {
            child = child.getChild(child.getNumberChildren() - 1);
        }
        while (child.getType() != 301015 && child.getType() != 301010) {
            child = child.getChild(0);
        }
        SQLProject projection = (SQLProject)child;
        SQLValueList vList = projection.getOutputList();
        List<SQLAlias> aliasList = vList.getAliasList();
        boolean supportsExpressionsInOrderBy = dataSource != null && dataSource.getCapabilities().isSupported("supports.expressionsInOrderBy");
        boolean supportsOrderByAlias = dataSource != null && dataSource.getCapabilities().isSupported("supports.orderByAlias");
        boolean supportsOrderByOrdinal = dataSource != null && dataSource.getCapabilities().isSupported("supports.orderByOrdinal");
        SQLSortKeyList sortKeyList = ((SQLSort)node).getSortKeyList();
        for (int i = 0; i < sortKeyList.getNumberChildren(); ++i) {
            SQLSortKey sortKey = (SQLSortKey)sortKeyList.getChild(i);
            IXQEQueryNode sortKeyExpr = sortKey.getChild(0);
            if (dataSource != null && !sortKey.isSupported(dataSource) || sortKeyExpr.getType() == 301031) {
                status = true;
                break;
            }
            if (!sortKey.isUnrelated() && sortKeyExpr.getType() == 301032 || sortKeyExpr.getType() == 301066) continue;
            Boolean aliasInExpression = false;
            if (aliasList != null) {
                IXQEQueryNode[] sqlFids;
                for (IXQEQueryNode sqlFid : sqlFids = sortKeyExpr.getChildrenOfCategory(301032)) {
                    String alias = null;
                    String name = null;
                    String tname = null;
                    name = ((SQLFid)sqlFid).getName();
                    tname = ((SQLFid)sqlFid).getTableName();
                    if (tname != null) continue;
                    for (int j = 0; j < aliasList.size(); ++j) {
                        SQLAlias sqlAlias = aliasList.get(j);
                        if (sqlAlias != null) {
                            alias = sqlAlias.getName();
                        }
                        if (alias == null || name == null || !name.equals(alias)) continue;
                        aliasInExpression = true;
                    }
                }
            }
            if (supportsExpressionsInOrderBy && !checkedChildSupport) {
                childSupported = dataSource != null && node.getChild(0).isSupported(dataSource);
                checkedChildSupport = true;
            }
            if ((supportsExpressionsInOrderBy || aliasInExpression.booleanValue() || !supportsOrderByAlias && !supportsOrderByOrdinal) && childSupported) continue;
            status = true;
            break;
        }
        if (status) {
            this.traceQueryCondition(status, "SORT operator is not supported.", trace);
        } else {
            this.traceQueryCondition(status, "SORT operator is supported.", trace);
        }
        return status;
    }

    private SQLSortKeyList eliminateLiterals(SQLSortKeyList node) {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = node.getChildren()) {
            int type = child.getType();
            if (type != 301031 && type != 301051 && type != 301050) continue;
            child.detach();
        }
        if (node.getNumberChildren() == 0) {
            node.detach();
            node = null;
        }
        return node;
    }
}

