/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqe.util.CollectionCast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class DecomposeSQLSortWithExpression
extends RQETransformation {
    static final String DERIVED_TABLE_NAME = "D1";

    public DecomposeSQLSortWithExpression() {
        this.mName = "Decompose SQLSort With Expression.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301019};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IXQEQueryNode baseQueryBlock = node.getChild(0);
        Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSortKeyList sortKeyList = ((SQLSort)node).getSortKeyList();
        if ((sortKeyList = this.eliminateLiterals(sortKeyList)) == null) {
            return;
        }
        IXQEQueryNode projectNode = baseQueryBlock.getChild(0);
        ((SQLQueryBlock)baseQueryBlock).setName(DERIVED_TABLE_NAME);
        if (projectNode.getType() == 301022) {
            projectNode = projectNode.getChild(projectNode.getNumberChildren() - 1);
        }
        while (projectNode.getType() != 301015 && projectNode.getType() != 301010) {
            projectNode = projectNode.getChild(0);
        }
        SQLValueList projection = ((SQLProject)projectNode).getOutputList();
        List<SQLAlias> aList = projection.getAliasList();
        for (int i = 0; i < sortKeyList.getNumberChildren(); ++i) {
            SQLSortKey sortKey = (SQLSortKey)sortKeyList.getChild(i);
            SQLQueryNode sortKeyExpr = (SQLQueryNode)sortKey.getChild(0);
            if (sortKeyExpr.getType() == 301032) continue;
            sortKeyExpr.detach();
            int index = projection.indexOf(sortKeyExpr);
            if (index < 0) {
                index = projection.getNumberChildren();
                projection.addChild(sortKeyExpr, index);
                if (aList != null) {
                    SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
                    aliasNode.setName("null");
                    aList.add(aliasNode);
                }
            }
            SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
            fid.setVirtualColumnNo(index);
            fid.setDataType(sortKeyExpr.getDataType());
            sortKey.addChild(fid);
            sortKey.setUnrelated(false);
        }
        List<IXQEQueryNode> derivedExpr = projection.getProjectableExpressions();
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        qBlock.setDataSourceList(dataSources);
        qBlock.setForeign(true);
        node.getChild(0).insertParent(qBlock);
        SQLProject newProject = (SQLProject)nodeFactory.createNode(301015);
        newProject.setCollapsible(false);
        qBlock.getChild(0).insertParent(newProject);
        projection.move(newProject);
        SQLValueList derivedProjection = SQLPreoptimizerUtil.buildProjection(environment, derivedExpr, 0, 0, qBlock.getDataSource());
        if (projectNode.getType() == 301010) {
            projectNode.addChild(derivedProjection, projectNode.getNumberChildren() - 1);
        } else {
            projectNode.addChild(derivedProjection);
        }
        ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
        for (int i = 0; i < derivedProjection.getNumberChildren(); ++i) {
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName("C" + i);
            aliasList.add(aliasNode);
        }
        derivedProjection.setAliasList(aliasList);
        qBlock.setQueryItemList(SQLPreoptimizerUtil.getQueryItemList(projection));
        List<SQLAlias> outerAliasList = projection.getAliasList();
        if (outerAliasList == null) {
            outerAliasList = new ArrayList<SQLAlias>(projection.getNumberChildren());
            for (int i = 0; i < projection.getNumberChildren(); ++i) {
                outerAliasList.add(null);
            }
            projection.setAliasList(outerAliasList);
        }
        for (int i = 0; i < projection.getNumberChildren(); ++i) {
            SQLFid fid;
            SQLAlias aliasNode;
            IXQEQueryNode child = projection.getChild(i);
            if (child.getType() != 301032 || (aliasNode = outerAliasList.get((fid = (SQLFid)child).getColumnNo())) != null || fid.getName() == null) continue;
            aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName(fid.getName());
            outerAliasList.set(fid.getColumnNo(), aliasNode);
        }
        List<SQLFid> fids = CollectionCast.downcast(projection.getDescendantsOfTypeOrdered(301032, 301004), IXQEQueryNode.class, SQLFid.class);
        for (SQLFid fid : fids) {
            fid.setName(((SQLAlias)aliasList.get(fid.getColumnNo())).getName());
            fid.setTableName(DERIVED_TABLE_NAME);
        }
        fids = CollectionCast.downcast(sortKeyList.getDescendantsOfTypeOrdered(301032, 301004), IXQEQueryNode.class, SQLFid.class);
        for (SQLFid fid : fids) {
            SQLFid pFid = (SQLFid)projection.getChild(fid.getVirtualColumnNo());
            fid.setName(pFid.getName());
            fid.setTableName(pFid.getTableName());
        }
        IXQEQueryNode[] children = sortKeyList.getChildren();
        for (int i = 0; i < children.length - 1; ++i) {
            if (children[i].getChild(0).getNodeType() != 301032) continue;
            SQLFid iChild = (SQLFid)children[i].getChild(0);
            for (int j = i + 1; j < children.length; ++j) {
                if (children[j].getChild(0).getNodeType() != 301032) continue;
                SQLFid jChild = (SQLFid)children[j].getChild(0);
                if (!iChild.getName().equals(jChild.getName()) || !iChild.getTableName().equals(jChild.getTableName())) continue;
                children[j].detach();
            }
        }
    }

    private SQLSortKeyList eliminateLiterals(SQLSortKeyList node) {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = node.getChildren()) {
            int type = child.getType();
            if (type != 301031 && type != 301051 && type != 301050) continue;
            child.detach();
        }
        if (node.getNumberChildren() == 0) {
            node.detach();
            node = null;
        }
        return node;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean status = false;
        if (dataSource != null && !dataSource.getCapabilities().isSupported("supports.expressionsInOrderBy") && !dataSource.getCapabilities().isSupported("supports.orderByAlias") && !dataSource.getCapabilities().isSupported("supports.orderByOrdinal") && dataSource.getCapabilities().isSupported("supports.orderByName")) {
            IXQEQueryNode child = node.getChild(0);
            if ((child = child.getChild(0)).getType() == 301018) {
                return status;
            }
            if (child.getType() == 301022) {
                child = child.getChild(child.getNumberChildren() - 1);
            }
            while (child.getType() != 301015 && child.getType() != 301010) {
                child = child.getChild(0);
            }
            SQLValueList vList = ((SQLProject)child).getOutputList();
            List<SQLAlias> aliasList = vList.getAliasList();
            SQLSortKeyList sortKeyList = ((SQLSort)node).getSortKeyList();
            SQLWith with = (SQLWith)node.getAncestorOfType(301022);
            boolean isInsideCTEBaseQuery = with != null && with.getChild(with.getNumberChildren() - 1) == pQueryBlock;
            for (int i = 0; i < sortKeyList.getNumberChildren() && aliasList != null && aliasList.size() >= sortKeyList.getNumberChildren(); ++i) {
                SQLQueryBlock qBlock;
                SQLSortKey sortKey = (SQLSortKey)sortKeyList.getChild(i);
                IXQEQueryNode sortKeyExpr = sortKey.getChild(0);
                if (sortKeyExpr.getType() != 301032 && sortKeyExpr.getType() != 301066) {
                    status = true;
                    break;
                }
                if (sortKeyExpr.getType() != 301032) continue;
                String alias = null;
                SQLAlias sqlAlias = aliasList.get(((SQLFid)sortKeyExpr).getVirtualColumnNo());
                IXQEQueryNode value = vList.getChild(((SQLFid)sortKeyExpr).getVirtualColumnNo());
                if (sqlAlias != null) {
                    alias = sqlAlias.getName();
                }
                if (alias == null || ((SQLFid)sortKeyExpr).getName() == null || !((SQLFid)sortKeyExpr).getName().equals(alias)) continue;
                if (value.getType() != 301032 && value.getType() != 301059) {
                    status = true;
                    break;
                }
                if (value.getType() != 301032 || !isInsideCTEBaseQuery || child.getChild(0).getType() != 301016 || !((SQLRelation)child.getChild(0)).isWithClauseQueryRef() || null == (qBlock = with.getQueryByName(((SQLRelation)child.getChild(0)).getName())) || qBlock.getBlockType() != 301015 && qBlock.getBlockType() != 301010 && qBlock.getBlockType() != 301008) continue;
                IXQEQueryNode cteProject = qBlock.getChild(0);
                while (cteProject.getType() != 301015 && cteProject.getType() != 301010) {
                    cteProject = cteProject.getChild(0);
                }
                SQLValueList vCTEList = ((SQLProject)cteProject).getOutputList();
                IXQEQueryNode valueInCTE = vCTEList.getChild(((SQLFid)value).getVirtualColumnNo());
                if (valueInCTE.getType() == 301032 || value.getType() == 301059) continue;
                status = true;
                break;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "SORT need to be decomposed.", trace);
        } else {
            this.traceQueryCondition(status, "SORT do not need to be decomposed.", trace);
        }
        return status;
    }
}

