/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EliminateExpressionFromOrderByClauseUnderAggregate
extends RQETransformation {
    public EliminateExpressionFromOrderByClauseUnderAggregate() {
        this.mName = "Eliminate Expressions from ORDER BY clause under an aggregate.";
        this.mPassNumbers = new int[]{14};
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        List<IXQEQueryNode> exprList = null;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getParent();
        Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
        IDataSource dataSource = pQueryBlock.getDataSource();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        SQLValueList projectList = (SQLValueList)node.getChild(1);
        SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        qBlock.setForeign(true);
        qBlock.setDataSourceList(dataSources);
        child.insertParent(qBlock);
        List<IXQEQueryNode> aggrList = projectList.getDescendantsOfTypeOrdered(301034, false);
        List<IXQEQueryNode> exprListUnderAggrOrderByClause = this.getExpressionsUnderAggregateOrderByClause(aggrList);
        exprList = projectList.getProjectableExpressionsExcludingAnchorList(dataSource, aggrList);
        if (groupByList != null) {
            exprList.addAll(groupByList.getProjectableExpressions(dataSource));
        }
        exprList = this.addExpressionsAndEliminateTheirDescendants(exprList, exprListUnderAggrOrderByClause);
        SQLQueryItemList sqlQueryItemList = null;
        SQLRelation sqlRelation = null;
        if (child instanceof SQLRelation) {
            sqlRelation = (SQLRelation)child;
        }
        if (sqlRelation != null) {
            sqlQueryItemList = sqlRelation.getQueryItemList();
        }
        SQLValueList vList = SQLPreoptimizerUtil.buildProjection(environment, exprList, 0, 0, dataSource, sqlQueryItemList);
        if (((SQLGroupBy)node).isReductionGroupBy()) {
            vList.setAliasList(projectList.getAliasList());
        }
        qBlock.setQueryItemList(SQLPreoptimizerUtil.getQueryItemList(child.getQueryItemList(), vList));
        SQLProject newProj = (SQLProject)nodeFactory.createNode(301015);
        qBlock.getChild(0).insertParent(newProj);
        newProj.addChild(vList);
        if (dataSource != null && newProj.isSupported(dataSource)) {
            qBlock.setForeign(true);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean status = false;
        SQLProject project = (SQLProject)node;
        SQLValueList vList = project.getOutputList();
        List<IXQEQueryNode> aggregateList = vList.getDescendantsOfTypeOrdered(301034, false);
        ArrayList<IXQEQueryNode> aggregateWithinGroupList = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode aggregate : aggregateList) {
            if (!aggregate.hasChildOfType(301021)) continue;
            aggregateWithinGroupList.add(aggregate);
        }
        boolean bl = status = !this.getExpressionsUnderAggregateOrderByClause(aggregateWithinGroupList).isEmpty();
        if (status && pQueryBlock.isForeign()) {
            IDataSource dataSource = pQueryBlock.getDataSource();
            IDataSourceCapabilities dsCapabilities = dataSource.getCapabilities();
            boolean bl2 = status = !dsCapabilities.isSupported("supports.expressionsInOrderBy");
        }
        if (status) {
            this.traceQueryCondition(status, "Aggregate ORDER BY clause contains unsupported expressions.", trace);
        } else {
            this.traceQueryCondition(status, "Aggregate ORDER BY clause doesn't contain expressions.", trace);
        }
        return status;
    }

    private List<IXQEQueryNode> getExpressionsUnderAggregateOrderByClause(List<IXQEQueryNode> aggrList) {
        ArrayList<IXQEQueryNode> exprList = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode aggr : aggrList) {
            IXQEQueryNode[] sortKeys;
            IXQEQueryNode sortKeyList = aggr.getFirstChildByType(301021);
            if (sortKeyList == null) continue;
            for (IXQEQueryNode node : sortKeys = sortKeyList.getChildren()) {
                if (node.getChild(0).getType() == 301032) continue;
                exprList.add(node.getChild(0));
            }
        }
        return exprList;
    }

    private List<IXQEQueryNode> addExpressionsAndEliminateTheirDescendants(List<IXQEQueryNode> exprList, List<IXQEQueryNode> exprListToBeAdded) {
        ArrayList<IXQEQueryNode> newExprList = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode expr : exprList) {
            boolean exclude = false;
            for (IXQEQueryNode exprToBeAdded : exprListToBeAdded) {
                if (expr != exprToBeAdded && !expr.isAncestor(exprToBeAdded)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            newExprList.add(expr);
        }
        newExprList.addAll(exprListToBeAdded);
        return newExprList;
    }
}

