/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.AmbiguousConnectionException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.util.CollectionCast;
import java.util.Collection;
import java.util.List;

public class GroupByPushDown
extends RQETransformation {
    public GroupByPushDown() {
        this.mName = "Push GROUP BY through join.";
        this.mPassNumbers = new int[]{24};
        this.mTypes = new int[]{301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        SQLGroupBy groupNode = (SQLGroupBy)qBlock.getChild(0);
        List<SQLFid> fidList = CollectionCast.downcast(groupNode.getGroupByList().getDescendantsOfTypeOrdered(301032, 301011), IXQEQueryNode.class, SQLFid.class);
        fidList.addAll(CollectionCast.downcast(groupNode.getDescendantsOfTypeOrdered(301032, new int[]{301029, 301011}), IXQEQueryNode.class, SQLFid.class));
        this.pushGroupBy(node, factory, fidList, 0);
        IRelationship.Cardinality cardinality = (IRelationship.Cardinality)((Object)((SQLJoin)node).getPropertyValue("rightCardinality"));
        if (cardinality == IRelationship.Cardinality.ZERO_MANY || cardinality == IRelationship.Cardinality.ONE_MANY) {
            this.pushGroupBy(node, factory, fidList, 1);
        }
    }

    private void pushGroupBy(IXQEQueryNode node, IXQENodeFactory factory, List<SQLFid> fidList, int sourceNo) {
        SQLValueList vList = (SQLValueList)factory.createNode(301030);
        for (SQLFid fid : fidList) {
            if (fid.getSourceNo() != sourceNo) continue;
            int columnNo = vList.indexOf(fid);
            if (columnNo < 0) {
                columnNo = vList.getNumberChildren();
                vList.addChild(factory.copyNode(fid));
            }
            fid.setColumnNo(columnNo);
            fid.setVirtualColumnNo(columnNo);
        }
        for (IXQEQueryNode vListExpr : vList.getChildren()) {
            ((SQLFid)vListExpr).setVirtualColumnNo(((SQLFid)vListExpr).getColumnNo());
        }
        SQLGroupBy groupBy = (SQLGroupBy)factory.createNode(301010);
        node.getChild(sourceNo).insertParent(groupBy);
        IXQEQueryNode groupByList = factory.createNode(301029);
        for (IXQEQueryNode fid : vList.getChildren()) {
            groupByList.addChild(factory.copyNode(fid));
        }
        groupBy.addChild(vList);
        groupBy.addChild(groupByList);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IXQEQueryNode child = qBlock.getChild(0);
        boolean status = true;
        for (int i = 0; i < 2 && status; ++i) {
            IXQEQueryNode subTree = node.getChild(i);
            if (subTree.getType() == 301004 && ((SQLQueryBlock)subTree).getChild(0).getType() != 301010 && !((SQLQueryBlock)subTree).isLateralDerivedTable()) continue;
            status = false;
        }
        if (status) {
            SQLJoin joinNode = (SQLJoin)node;
            boolean datasetRef = false;
            Collection<IDataSource> dataSources = qBlock.getDataSourceList();
            for (IDataSource iDataSource : dataSources) {
                try {
                    if (iDataSource == null || !DataSourceTypeEnum.isColumnar(iDataSource.getType())) continue;
                    datasetRef = true;
                    break;
                }
                catch (AmbiguousConnectionException e) {
                }
            }
            boolean bl = status = datasetRef && !qBlock.isForeign() && child.getType() == 301010 && ((SQLGroupBy)child).isReductionGroupBy() && joinNode.getJoinType() == SQLJoin.SubType.INNER && joinNode.getPropertyValue("leftCardinality") != null && joinNode.getPropertyValue("rightCardinality") != null;
            if (status) {
                SQLGroupByList groupByList = ((SQLGroupBy)child).getGroupByList();
                for (IXQEQueryNode groupByExpr : groupByList.getChildren()) {
                    if (groupByExpr.getType() == 301032) continue;
                    status = false;
                    break;
                }
                if (status) {
                    BitMask bitMask = new BitMask(2);
                    for (IXQEQueryNode groupByExpr : groupByList.getChildren()) {
                        bitMask.set(((SQLFid)groupByExpr).getSourceNo());
                    }
                    boolean bl2 = status = bitMask.length() == 2;
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "GROUP BY can be pushed through join.", trace);
        } else {
            this.traceQueryCondition(status, "GROUP BY cannot be pushed through join.", trace);
        }
        return status;
    }
}

