/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.optimization.CreateSortForWindowedAggregates;
import com.cognos.xqe.transformation.relational.preoptimization.DecomposeSQLJoin;
import com.cognos.xqe.transformation.relational.preoptimization.DecomposeSQLProduct;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class PushDatabaseFunctionsDown
extends RQETransformation {
    public PushDatabaseFunctionsDown() {
        this.mName = "Push database functions to leaf queries.";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 11;
        this.mTypes = new int[]{301033};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(IXQEQueryNode function, IPlanningEnvironment environment) {
        boolean moved = false;
        SQLValueList projectionList = null;
        List<SQLQueryBlock> derivedQueryList = this.findDerivedQueryBlocks(function, environment);
        for (int derivedQueryIdx = 0; derivedQueryIdx < derivedQueryList.size(); ++derivedQueryIdx) {
            void var22_27;
            List<String> dcList;
            List<SQLAlias> aList;
            int i;
            IXQEQueryNode joinOrProductNode;
            XQENodeFactory factory;
            SQLQueryBlock derivedQuery = derivedQueryList.get(derivedQueryIdx);
            if (derivedQueryIdx > 0) {
                factory = environment.getNodeFactory();
                function = factory.deepCopyNode(function);
            }
            if ((projectionList = derivedQuery.getOutputList()) == null) continue;
            factory = environment.getNodeFactory();
            SQLFid newFid = (SQLFid)factory.createNode(301032);
            SQLFid copiedNewFid = null;
            int numOfColumns = projectionList.getNumberChildren();
            SQLFid fidUnderFunc = (SQLFid)function.getFirstDescendantOfTypeOrdered(301032, false);
            int sourceNo = 0;
            int vColumnOffset = 0;
            if (this.isChildOfJoinOrProductNode(derivedQuery) && (sourceNo = (joinOrProductNode = derivedQuery.getParent()).getPositionOfChild(derivedQuery)) == 1) {
                SQLQueryNode leftSide = (SQLQueryNode)joinOrProductNode.getChild(0);
                vColumnOffset = leftSide.getQueryItemList().size();
            }
            if (fidUnderFunc != null) {
                sourceNo = fidUnderFunc.getSourceNo();
                newFid.setTableName(fidUnderFunc.getTableName());
                vColumnOffset = fidUnderFunc.getVirtualColumnNo() - fidUnderFunc.getColumnNo();
            }
            newFid.setSourceNo(sourceNo);
            newFid.setColumnNo(numOfColumns);
            newFid.setVirtualColumnNo(numOfColumns + vColumnOffset);
            newFid.setDataType(DataTypeFactory.getVariantType());
            SQLQueryBlock parentQueryBlock = (SQLQueryBlock)function.getAncestorOfType(301004);
            ArrayList<SQLFid> copiedNewFids = null;
            if (parentQueryBlock != null) {
                IXQEQueryNode[] functionNodes = parentQueryBlock.getDescendantsOfType(301033, false, 301004);
                for (i = 0; i < functionNodes.length; ++i) {
                    if (functionNodes[i] == function || !functionNodes[i].isSameExpression(function, false)) continue;
                    copiedNewFid = (SQLFid)factory.deepCopyNode(newFid);
                    functionNodes[i].exchange(copiedNewFid);
                    if (copiedNewFids == null) {
                        copiedNewFids = new ArrayList<SQLFid>();
                    }
                    copiedNewFids.add(copiedNewFid);
                }
            }
            if (derivedQueryIdx == 0) {
                function.exchange(newFid);
            }
            if ((aList = projectionList.getAliasList()) != null) {
                for (i = 0; i < projectionList.getNumberChildren(); ++i) {
                    if (aList.get(i) != null || projectionList.getChild(i).getType() != 301032) continue;
                    SQLAlias aliasNode = (SQLAlias)factory.createNode(301028);
                    aliasNode.setName(((SQLFid)projectionList.getChild(i)).getName());
                    aList.set(i, aliasNode);
                }
            }
            String newProjectionName = this.getNewProjectionName(projectionList);
            SQLQueryItemList qList = derivedQuery.getQueryItemList();
            if (qList != null) {
                SQLQueryItem qItem = new SQLQueryItem(newProjectionName, newFid.getDataType(), newFid.getVirtualColumnNo());
                qList.add(qItem);
            }
            if ((dcList = derivedQuery.getDerivedColumnList()) != null) {
                dcList.add(newProjectionName);
            }
            newFid.setName(newProjectionName);
            if (copiedNewFids != null) {
                for (IXQEQueryNode iXQEQueryNode : copiedNewFids) {
                    ((SQLFid)iXQEQueryNode).setName(newProjectionName);
                }
            }
            projectionList.addChild(function);
            IXQEQueryNode[] fids = function.getDescendantsOfType(301032, false);
            boolean bl = false;
            while (var22_27 < fids.length) {
                SQLFid fid = (SQLFid)fids[var22_27];
                IXQEQueryNode newNode = projectionList.getChild(fid.getColumnNo());
                newNode = factory.deepCopyNode(newNode);
                fid.exchange(newNode);
                ++var22_27;
            }
            SQLAlias sQLAlias = (SQLAlias)factory.createNode(301028);
            sQLAlias.setName(newProjectionName);
            if (projectionList.getAliasList() == null) {
                ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
                projectionList.setAliasList(aliasList);
                for (int i3 = 0; i3 < qList.size() - 1; ++i3) {
                    SQLAlias alias1 = (SQLAlias)factory.createNode(301028);
                    alias1.setName(((SQLQueryItem)qList.get(i3)).getName());
                    aliasList.add(alias1);
                }
            }
            ArrayList<SQLAlias> newAliasList = new ArrayList<SQLAlias>(projectionList.getAliasList());
            newAliasList.add(sQLAlias);
            projectionList.setAliasList(newAliasList);
            moved = true;
            derivedQuery.setNumberColumns(projectionList.getNumberChildren());
        }
        if (!moved) {
            function.setPropertyValue("IsPushedFarEnough", Boolean.TRUE);
        }
    }

    private String getNewProjectionName(SQLValueList valueList) {
        int cNum = 1;
        String cChar = "C";
        List<SQLAlias> aliasList = valueList.getAliasList();
        HashSet<String> columnNames = new HashSet<String>();
        if (aliasList != null) {
            for (SQLAlias a : aliasList) {
                if (a == null) continue;
                columnNames.add(a.getName());
            }
        } else {
            for (IXQEQueryNode node : valueList.getChildren()) {
                if (node.getType() != 301032) continue;
                columnNames.add(((SQLFid)node).getName());
            }
        }
        for (String name : columnNames) {
            int num;
            if (name.equals("C") || !name.matches("C[0-9]+") || (num = Integer.parseInt(name.substring(1))) <= cNum) continue;
            cNum = num;
        }
        String cName = "C" + (cNum + 1);
        return cName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SQLQueryBlock> findDerivedQueryBlocks(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock parent;
        ArrayList<SQLQueryBlock> queryBlockList = new ArrayList<SQLQueryBlock>();
        SQLQueryBlock sourceBlock = null;
        IXQEQueryNode[] fids = node.getDescendantsOfType(301032, false, 301059);
        if (fids.length > 1) {
            int sourceNo = ((SQLFid)fids[0]).getSourceNo();
            for (int i = 1; i < fids.length; ++i) {
                if (sourceNo == ((SQLFid)fids[i]).getSourceNo()) continue;
                return Collections.emptyList();
            }
        }
        if ((sourceBlock = (SQLQueryBlock)(parent = (SQLQueryBlock)node.getAncestorOfType(301004)).getFirstDescendantOfTypeOrdered(301004, false)) != null) {
            IXQEQueryNode temp;
            if (this.isChildOfJoinOrProductNode(sourceBlock)) {
                IXQEQueryNode joinNode = sourceBlock.getParent();
                IXQEQueryNode productNodeOnTopOfJoin = null;
                if (joinNode.getParent() != null && joinNode.getParent().getNodeType() == 301014) {
                    productNodeOnTopOfJoin = joinNode.getParent();
                }
                if (!(this.isJoinNodeThatWillBeLocallyProcessed(joinNode, environment) || productNodeOnTopOfJoin != null && this.isJoinNodeThatWillBeLocallyProcessed(productNodeOnTopOfJoin, environment))) {
                    return Collections.emptyList();
                }
                if (fids.length > 0) {
                    IXQEQueryNode matchingJoinLeg = this.getJoinChildWithMatchingTableName(joinNode, ((SQLFid)fids[0]).getTableName());
                    if (matchingJoinLeg == null && productNodeOnTopOfJoin != null) {
                        matchingJoinLeg = this.getJoinChildWithMatchingTableName(productNodeOnTopOfJoin, ((SQLFid)fids[0]).getTableName());
                    }
                    if (matchingJoinLeg == null) return Collections.emptyList();
                    sourceBlock = (SQLQueryBlock)matchingJoinLeg;
                }
            } else if (this.hasSetOperatorChild(sourceBlock)) {
                IDataSource dataSource = sourceBlock.getDataSource();
                if (dataSource == null || sourceBlock.isSupported(dataSource)) return queryBlockList;
                SQLSetOperator setOp = (SQLSetOperator)sourceBlock.getChild(0);
                this.getSetOperatorQueryBlockLegs(setOp, queryBlockList);
                return queryBlockList;
            }
            for (temp = sourceBlock.getParent(); temp != parent && temp.getNodeType() != 301076; temp = temp.getParent()) {
            }
            if (temp != parent) {
                return Collections.emptyList();
            }
        }
        if (sourceBlock == null) {
            int[] types = new int[]{301018};
            List<IXQEQueryNode> subQueries = parent.getDescendantsOfTypesOrdered(types, false);
            if (!subQueries.isEmpty()) {
                return Collections.emptyList();
            }
            SQLRelation relation = (SQLRelation)parent.getFirstDescendantOfTypeOrdered(301016, false);
            if (relation != null && relation.isWithClauseQueryRef()) {
                if (this.isChildOfJoinOrProductNode(relation)) {
                    if (!this.isJoinNodeThatWillBeLocallyProcessed(relation.getParent(), environment)) {
                        return Collections.emptyList();
                    }
                    if (fids.length > 0) {
                        IXQEQueryNode matchingJoinLeg = this.getJoinChildWithMatchingTableName(relation.getParent(), ((SQLFid)fids[0]).getTableName());
                        if (matchingJoinLeg == null) return Collections.emptyList();
                        relation = (SQLRelation)matchingJoinLeg;
                    }
                }
                SQLWith sqlWith = (SQLWith)relation.getAncestorOfType(301022);
                sourceBlock = sqlWith.getQueryByName(relation.getName());
            }
        }
        if (sourceBlock == null) return queryBlockList;
        int blockType = sourceBlock.getBlockType();
        if (blockType == 301052) {
            return Collections.emptyList();
        }
        if (blockType != 301015 && blockType != 301010 && blockType != 301008 && blockType != 301019) {
            return Collections.emptyList();
        }
        queryBlockList.add(sourceBlock);
        return queryBlockList;
    }

    private boolean isChildOfJoinOrProductNode(IXQEQueryNode node) {
        return node.getParent() != null && (node.getParent().getNodeType() == 301011 || node.getParent().getNodeType() == 301014);
    }

    private boolean hasSetOperatorChild(IXQEQueryNode node) {
        return node.getChild(0) != null && node.getChild(0).getNodeType() == 301018;
    }

    private void getSetOperatorQueryBlockLegs(SQLSetOperator setOp, List<SQLQueryBlock> queryBlockList) {
        if (setOp.getNumberChildren() == 2 && setOp.getChild(0).getNodeType() == 301004 && setOp.getChild(1).getNodeType() == 301004) {
            for (int i = 0; i < setOp.getNumberChildren(); ++i) {
                SQLQueryBlock sqlQueryBlock = (SQLQueryBlock)setOp.getChild(i);
                if (this.hasSetOperatorChild(sqlQueryBlock)) {
                    this.getSetOperatorQueryBlockLegs((SQLSetOperator)sqlQueryBlock.getChild(0), queryBlockList);
                    continue;
                }
                queryBlockList.add(sqlQueryBlock);
            }
        }
    }

    private boolean isJoinNodeThatWillBeLocallyProcessed(IXQEQueryNode node, IPlanningEnvironment environment) {
        RQETransformation tr;
        if (node.getNodeType() == 301011 && ((DecomposeSQLJoin)(tr = new DecomposeSQLJoin())).passesNodeCondition(node, environment)) {
            return true;
        }
        return node.getNodeType() == 301014 && ((DecomposeSQLProduct)(tr = new DecomposeSQLProduct())).passesNodeCondition(node, environment);
    }

    private IXQEQueryNode getJoinChildWithMatchingTableName(IXQEQueryNode sqlJoin, String tableNameToMatch) {
        if (tableNameToMatch == null) {
            return null;
        }
        IXQEQueryNode[] joinChildren = sqlJoin.getChildren();
        for (int i = 0; i < joinChildren.length; ++i) {
            String joinLegTableName = null;
            if (joinChildren[i].getNodeType() == 301004) {
                joinLegTableName = ((SQLQueryBlock)joinChildren[i]).getName();
            } else if (joinChildren[i].getNodeType() == 301016) {
                joinLegTableName = ((SQLRelation)joinChildren[i]).getName();
            }
            if (joinLegTableName == null || !joinLegTableName.equals(tableNameToMatch)) continue;
            return joinChildren[i];
        }
        return null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode[] aggrs;
        IFunction f;
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLFunction function = (SQLFunction)node;
        boolean bl = status = function.getSubType() == SQLFunction.SubType.UDF && function.getBooleanPropertyValue("IsPushedFarEnough") == null;
        if (status && (f = FunctionManager.getUserDefinedFunction(function.getFunctionName(), function.getParameterTypes())) != null && !f.isDbFunction()) {
            status = false;
        }
        SQLQueryBlock parentQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        if (status) {
            IDataSource dataSource = parentQueryBlock.getDataSource();
            boolean bl2 = status = dataSource != null && !parentQueryBlock.isSupported(dataSource);
        }
        if (status && (aggrs = node.getDescendantsOfType(301034, false, 301059)).length > 0 && !CreateSortForWindowedAggregates.sortRequired(parentQueryBlock)) {
            status = false;
        }
        if (status) {
            this.traceQueryCondition(status, "The DB function needs to be pushed down.", trace);
        } else {
            this.traceQueryCondition(status, "The DB function can not be pushed down.", trace);
        }
        return status;
    }
}

