/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class RemoveLiteralsFromGroupBy
extends RQETransformation {
    public RemoveLiteralsFromGroupBy(int[] passNumbers) {
        this.mName = "Eliminate literals/parameters/subqueries from Group By.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode[] children;
        SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
        for (IXQEQueryNode child : children = groupByList.getChildren()) {
            int type = child.getType();
            if (type != 301031 && type != 301051 && type != 301050 && type != 301059) continue;
            child.detach();
        }
        if (node.getNumberChildren() == 0) {
            node.detach();
            node = null;
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
        if (groupByList != null) {
            IXQEQueryNode child = null;
            int type = 0;
            for (int i = 0; i < groupByList.getNumberChildren(); ++i) {
                child = groupByList.getChild(i);
                type = child.getType();
                if (type != 301031 && type != 301051 && type != 301050 && type != 301059) continue;
                status = true;
                break;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "GROUP BY specification contains literals or parameters or subqueries.", trace);
        } else {
            this.traceQueryCondition(status, "GROUP BY specification doesn't contains literals or parameters or subqueries.", trace);
        }
        return status;
    }
}

