/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.List;

public class RemoveRedundantSQLWith
extends RQETransformation {
    public RemoveRedundantSQLWith() {
        this.mName = "Remove a redundant WITh clause from a sorted query.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301022};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getParent();
        SQLValueList outerList = ((SQLQueryNode)node).getOutputList();
        SQLQueryNode cte = (SQLQueryNode)node.getChild(0).detach();
        node.detach();
        pQueryBlock.addChild(cte);
        cte.extract();
        SQLValueList innerList = pQueryBlock.getOutputList();
        if (innerList != null) {
            List<SQLAlias> outerAliasList = outerList.getAliasList();
            List<SQLAlias> innerAliasList = innerList.getAliasList();
            if (innerAliasList == null) {
                innerList.setAliasList(outerAliasList);
            } else if (outerAliasList != null) {
                for (int i = 0; i < outerAliasList.size(); ++i) {
                    SQLAlias alias = outerAliasList.get(i);
                    if (alias == null) continue;
                    innerAliasList.set(i, alias);
                }
            }
            SQLSort sort = RemoveRedundantSQLWith.getSortNodeIfExists(innerList.getParent());
            if (sort != null) {
                SQLSortKeyList sortKeyList = sort.getSortKeyList();
                for (int i = 0; i < sortKeyList.getNumberChildren(); ++i) {
                    SQLSortKey sortKey = (SQLSortKey)sortKeyList.getChild(i);
                    if (sortKey.isUnrelated()) continue;
                    List<IXQEQueryNode> fidList = sortKey.getDescendantsOfTypeOrdered(301032, false);
                    for (int j = 0; j < fidList.size(); ++j) {
                        SQLFid fid = (SQLFid)fidList.get(j);
                        fid.setName(innerList.getName(fid.getVirtualColumnNo()));
                        fid.setTableName(innerList.getQualifier(fid.getVirtualColumnNo()));
                    }
                }
            }
            if (pQueryBlock.getChild(0).getType() == 301019) {
                pQueryBlock.setForeign(false);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLWith sqlWith = (SQLWith)node;
        boolean status = RemoveRedundantSQLWith.isCollapsible(sqlWith);
        if (status) {
            this.traceQueryCondition(status, "There is a SORT node in the main query of a WITH clause.", trace);
        } else {
            this.traceQueryCondition(status, "There is no SORT node in the main query of a WITH clause.", trace);
        }
        return status;
    }

    public static boolean isCollapsible(SQLWith sqlWith) {
        SQLQueryBlock cte;
        int ncte;
        boolean status = false;
        SQLQueryBlock pBlock = (SQLQueryBlock)sqlWith.getParent();
        if (pBlock.getName() == null && (ncte = sqlWith.getNumberChildren() - 1) == 1 && (cte = (SQLQueryBlock)sqlWith.getChild(0)).getReferenceCount() == 1) {
            SQLRelation relation;
            SQLProject project;
            SQLQueryNode mQuery = (SQLQueryNode)sqlWith.getChild(1);
            if (mQuery.getType() == 301004 && ((SQLQueryBlock)mQuery).getBlockType() == 301015 && (project = (SQLProject)mQuery.getChild(0)).getChild(0).getType() == 301016 && (relation = (SQLRelation)project.getChild(0)).isWithClauseQueryRef()) {
                SQLValueList vList = (SQLValueList)project.getChild(1);
                int nColumns = cte.getNumberColumns();
                if (vList.getNumberChildren() == nColumns) {
                    status = true;
                    for (int i = 0; i < nColumns; ++i) {
                        IXQEQueryNode exprNode = vList.getChild(i);
                        if (exprNode.getType() == 301032 && ((SQLFid)exprNode).getVirtualColumnNo() == i) continue;
                        status = false;
                        break;
                    }
                }
            }
            if (status) {
                IXQEQueryNode cte1;
                IXQEQueryNode mQuery1;
                status = false;
                if (cte.getBlockType() == 301019) {
                    status = true;
                } else if (cte.getBlockType() == 301060) {
                    status = true;
                } else if (cte.getBlockType() == 301022 && (mQuery1 = (cte1 = cte.getChild(0)).getChild(cte1.getNumberChildren() - 1)).getType() == 301004 && (((SQLQueryBlock)mQuery1).getBlockType() == 301019 || ((SQLQueryBlock)mQuery1).getBlockType() == 301060)) {
                    status = true;
                }
            }
        }
        return status;
    }

    private static SQLSort getSortNodeIfExists(IXQEQueryNode node) {
        while (node != null && node.getType() != 301019 && (node.getType() == 301004 || node.getType() != 301008 || node.getType() != 301060)) {
            node = node.getParent();
        }
        if (node != null && node.getType() == 301019) {
            return (SQLSort)node;
        }
        return null;
    }
}

