/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.preoptimization.DecomposeSQLWith;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public final class ReplaceCTERefWithDerivedTable
extends RQETransformation {
    public ReplaceCTERefWithDerivedTable() {
        this.mName = "Replace CTE reference with derived table.";
        this.mPassNumbers = new int[]{22};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mTypes = new int[]{301022};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        List<IXQEQueryNode> list = node.getDescendantsOfTypeOrdered(301016, false);
        for (IXQEQueryNode child : list) {
            SQLRelation rNode = (SQLRelation)child;
            SQLQueryBlock parentQB = (SQLQueryBlock)rNode.getAncestorOfType(301004);
            SQLQueryBlock qBlockUnderWith = ((SQLWith)node).getQueryByName(rNode.getName());
            boolean rNodeHasMatchingChildQBlockUnderWith = qBlockUnderWith != null;
            if (!rNodeHasMatchingChildQBlockUnderWith || !rNode.isWithClauseQueryRef() || !parentQB.isForeign()) continue;
            ReplaceCTERefWithDerivedTable.replaceRelationWithCTEExpression(rNode, qBlockUnderWith, nodeFactory);
        }
        DecomposeSQLWith.updateWithClause((SQLWith)node);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        if (dataSource != null && qBlock.getBooleanPropertyValue("decomposeSQLWith") == Boolean.TRUE && !qBlock.isForeign()) {
            List<IXQEQueryNode> list = node.getDescendantsOfTypeOrdered(301016, false);
            for (IXQEQueryNode child : list) {
                SQLRelation rNode = (SQLRelation)child;
                SQLQueryBlock parentQB = (SQLQueryBlock)rNode.getAncestorOfType(301004);
                SQLQueryBlock qBlockUnderWith = ((SQLWith)node).getQueryByName(rNode.getName());
                boolean rNodeHasMatchingChildQBlockUnderWith = qBlockUnderWith != null;
                if (!rNodeHasMatchingChildQBlockUnderWith || !rNode.isWithClauseQueryRef() || !parentQB.isForeign()) continue;
                status = true;
                break;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "At least one relation node needs to be replaced with a CTE expression.", trace);
        } else {
            this.traceQueryCondition(status, "No relation nodes need to be replaced with CTE expressions.", trace);
        }
        return status;
    }

    private static void replaceRelationWithCTEExpression(SQLRelation rNode, SQLQueryBlock qBlockUnderWith, IXQENodeFactory nodeFactory) {
        if (qBlockUnderWith.getReferenceCount() == 1) {
            qBlockUnderWith.move(rNode);
            rNode.extract();
        } else {
            SQLQueryBlock copied = (SQLQueryBlock)nodeFactory.deepCopyNode(qBlockUnderWith);
            rNode.exchange(copied);
            if (copied.getParent().getType() == 301004) {
                if (copied.getDerivedColumnList() != null) {
                    ((SQLQueryBlock)copied.getParent()).setDerivedColumnList(copied.getDerivedColumnList());
                }
                copied.extract();
            }
            qBlockUnderWith.decrementReferenceCount();
        }
    }
}

