/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLIsDistinctFrom;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class RewriteIsNotDistinctFromExpression
extends RQETransformation {
    public RewriteIsNotDistinctFromExpression() {
        this.mName = "Rewrite is not distinct from expression.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301027, 301075};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (node.getType() == 301027) {
            node.exchange(node.getChild(0));
        } else {
            SQLComparison compNode = (SQLComparison)nodeFactory.createNode(301026);
            compNode.setSubType(SQLComparison.SubType.EQUAL);
            node.exchange(compNode, true);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean bl = status = dataSource != null && (node.getType() == 301075 || ((SQLLogical)node).getSubType() == SQLLogical.SubType.OR);
        if (status) {
            SQLQueryNode leftExpr = (SQLQueryNode)node.getChild(0);
            SQLQueryNode rightExpr = (SQLQueryNode)node.getChild(1);
            if (node.getType() == 301027) {
                boolean bl2 = status = leftExpr.getType() == 301026 && ((SQLComparison)leftExpr).getSubType() == SQLComparison.SubType.EQUAL && rightExpr.getType() == 301027 && ((SQLLogical)rightExpr).getSubType() == SQLLogical.SubType.AND;
                if (status) {
                    boolean bl3 = status = rightExpr.getChild(0).getType() == 301024 && rightExpr.getChild(1).getType() == 301024;
                }
                if (status) {
                    status = leftExpr.getChild(0).isSameExpression(rightExpr.getChild(0).getChild(0), false) && leftExpr.getChild(1).isSameExpression(rightExpr.getChild(1).getChild(0), false);
                }
            } else {
                status = ((SQLIsDistinctFrom)node).isNegated();
            }
            if (status) {
                boolean bl4 = status = !dataSource.getCapabilities().isSupported("performance.generateEqualOrNull") || !leftExpr.isNullable() && !rightExpr.isNullable();
            }
        }
        if (status) {
            this.traceQueryCondition(status, "The is distinct from expression can be rewritten.", trace);
        } else {
            this.traceQueryCondition(status, "The is distinct from expression cannot be rewritten.", trace);
        }
        return status;
    }
}

